/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.alphabet;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.automatalib.common.smartcollection.ArrayWritable;
import net.automatalib.common.util.mapping.Mapping;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Alphabet<I>
extends ArrayWritable<I>,
Collection<I>,
Comparator<I>,
IntFunction<I>,
ToIntFunction<I> {
    @Override
    default public I apply(int index) {
        return this.getSymbol(index);
    }

    public I getSymbol(int var1);

    @Override
    default public int applyAsInt(I symbol) {
        return this.getSymbolIndex(symbol);
    }

    public int getSymbolIndex(I var1);

    @Override
    default public int compare(I o1, I o2) {
        return this.getSymbolIndex(o1) - this.getSymbolIndex(o2);
    }

    @Override
    default public void writeToArray(int offset, @Nullable Object[] array, int tgtOfs, int num) {
        for (int i = 0; i < num; ++i) {
            array[tgtOfs + i] = this.getSymbol(offset + i);
        }
    }

    default public <I2> Mapping<I2, I> translateFrom(Alphabet<I2> other) {
        if (other.size() > this.size()) {
            throw new IllegalArgumentException("Cannot translate from an alphabet with " + other.size() + " elements into an alphabet with only " + this.size() + " elements");
        }
        return i -> this.getSymbol(other.getSymbolIndex(i));
    }

    default public boolean containsSymbol(I symbol) {
        try {
            int index = this.getSymbolIndex(symbol);
            if (index < 0 || index >= this.size()) {
                return false;
            }
            return Objects.equals(symbol, this.getSymbol(index));
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }
}

