/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph.ads;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.graph.Graph;
import net.automatalib.visualization.VisualizationHelper;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public interface RecursiveADSNode<S, I, O, N extends RecursiveADSNode<S, I, O, N>>
extends Graph<N, N> {
    @Pure
    public @Nullable I getSymbol();

    public void setSymbol(I var1);

    @Pure
    public @Nullable N getParent();

    public void setParent(N var1);

    default public Collection<N> getNodesForRoot(N root) {
        ArrayList<RecursiveADSNode> result = new ArrayList<RecursiveADSNode>();
        ArrayDeque<N> queue = new ArrayDeque<N>();
        queue.add(root);
        while (!queue.isEmpty()) {
            @NonNull RecursiveADSNode node = (RecursiveADSNode)queue.poll();
            result.add(node);
            queue.addAll(node.getChildren().values());
        }
        return Collections.unmodifiableList(result);
    }

    public Map<O, N> getChildren();

    @Override
    default public Collection<N> getOutgoingEdges(N node) {
        return Collections.unmodifiableCollection(node.getChildren().values());
    }

    @Override
    default public N getTarget(N edge) {
        return edge;
    }

    @Override
    default public VisualizationHelper<N, N> getVisualizationHelper() {
        return new VisualizationHelper<N, N>(){

            @Override
            public boolean getNodeProperties(N node, Map<String, String> properties) {
                if (node.isLeaf()) {
                    properties.put("shape", "box");
                    properties.put("label", String.valueOf(node.getHypothesisState()));
                } else {
                    properties.put("label", node.toString());
                    properties.put("shape", "oval");
                }
                return true;
            }

            @Override
            public boolean getEdgeProperties(N src, N edge, N tgt, Map<String, String> properties) {
                for (Map.Entry e : src.getChildren().entrySet()) {
                    if (!((RecursiveADSNode)e.getValue()).equals(tgt)) continue;
                    properties.put("label", String.valueOf(e.getKey()));
                    return true;
                }
                return true;
            }
        };
    }

    public boolean isLeaf();

    public @Nullable S getHypothesisState();

    public void setHypothesisState(S var1);
}

