/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.formula.visitor;

import net.automatalib.modelchecker.m3c.formula.AndNode;
import net.automatalib.modelchecker.m3c.formula.AtomicNode;
import net.automatalib.modelchecker.m3c.formula.BoxNode;
import net.automatalib.modelchecker.m3c.formula.DiamondNode;
import net.automatalib.modelchecker.m3c.formula.FalseNode;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.formula.NotNode;
import net.automatalib.modelchecker.m3c.formula.OrNode;
import net.automatalib.modelchecker.m3c.formula.TrueNode;
import net.automatalib.modelchecker.m3c.formula.ctl.AFNode;
import net.automatalib.modelchecker.m3c.formula.ctl.AGNode;
import net.automatalib.modelchecker.m3c.formula.ctl.AUNode;
import net.automatalib.modelchecker.m3c.formula.ctl.AWUNode;
import net.automatalib.modelchecker.m3c.formula.ctl.EFNode;
import net.automatalib.modelchecker.m3c.formula.ctl.EGNode;
import net.automatalib.modelchecker.m3c.formula.ctl.EUNode;
import net.automatalib.modelchecker.m3c.formula.ctl.EWUNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.GfpNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.LfpNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.VariableNode;
import net.automatalib.modelchecker.m3c.formula.visitor.FormulaNodeVisitor;

public class CTLToMuCalc<L, AP>
implements FormulaNodeVisitor<FormulaNode<L, AP>, L, AP> {
    private int numFixedPointVars = 0;

    public FormulaNode<L, AP> toMuCalc(FormulaNode<L, AP> ctlFormula) {
        this.numFixedPointVars = 0;
        return this.visit((FormulaNode)ctlFormula);
    }

    @Override
    public FormulaNode<L, AP> visit(FormulaNode<L, AP> node) {
        return (FormulaNode)node.accept(this);
    }

    @Override
    public FormulaNode<L, AP> visit(AFNode<L, AP> node) {
        Object p = this.visit(node.getChild());
        String fixedPointVar = this.getFixedPointVar();
        DiamondNode hasSuccessor = new DiamondNode(new TrueNode());
        BoxNode allSuccessorSatisfyX = new BoxNode(new VariableNode(fixedPointVar));
        AndNode and = new AndNode(hasSuccessor, allSuccessorSatisfyX);
        OrNode or = new OrNode(p, and);
        return new LfpNode(fixedPointVar, or);
    }

    @Override
    public FormulaNode<L, AP> visit(AGNode<L, AP> node) {
        Object p = this.visit(node.getChild());
        String fixedPointVar = this.getFixedPointVar();
        BoxNode allSuccessorsSatisfyX = new BoxNode(new VariableNode(fixedPointVar));
        AndNode and = new AndNode(p, allSuccessorsSatisfyX);
        return new GfpNode(fixedPointVar, and);
    }

    @Override
    public FormulaNode<L, AP> visit(AUNode<L, AP> node) {
        Object p = this.visit(node.getLeftChild());
        Object q = this.visit(node.getRightChild());
        String fixedPointVar = this.getFixedPointVar();
        DiamondNode hasSuccessor = new DiamondNode(new TrueNode());
        BoxNode allSuccessorsSatisfyX = new BoxNode(new VariableNode(fixedPointVar));
        AndNode innerAnd = new AndNode(hasSuccessor, allSuccessorsSatisfyX);
        AndNode outerAnd = new AndNode(p, innerAnd);
        OrNode or = new OrNode(q, outerAnd);
        return new LfpNode(fixedPointVar, or);
    }

    @Override
    public FormulaNode<L, AP> visit(AWUNode<L, AP> node) {
        Object p = this.visit(node.getLeftChild());
        Object q = this.visit(node.getRightChild());
        AndNode and = new AndNode(new NotNode(p), new NotNode(q));
        EUNode ewu = new EUNode(new NotNode(this.visit(node.getRightChild())), and);
        return this.visit(new NotNode(ewu));
    }

    @Override
    public FormulaNode<L, AP> visit(EFNode<L, AP> node) {
        String fixedPointVar = this.getFixedPointVar();
        Object p = this.visit(node.getChild());
        DiamondNode hasSuccessorSatisfyingX = new DiamondNode(new VariableNode(fixedPointVar));
        OrNode orNode = new OrNode(p, hasSuccessorSatisfyingX);
        return new LfpNode(fixedPointVar, orNode);
    }

    @Override
    public FormulaNode<L, AP> visit(EGNode<L, AP> node) {
        String fixedPointVar = this.getFixedPointVar();
        Object childNode = this.visit(node.getChild());
        DiamondNode hasSuccessorSatisfyingX = new DiamondNode(new VariableNode(fixedPointVar));
        BoxNode hasNoSuccessor = new BoxNode(new FalseNode());
        OrNode or = new OrNode(hasSuccessorSatisfyingX, hasNoSuccessor);
        AndNode and = new AndNode(childNode, or);
        return new GfpNode(fixedPointVar, and);
    }

    @Override
    public FormulaNode<L, AP> visit(EUNode<L, AP> node) {
        String fixedPointVar = this.getFixedPointVar();
        Object p = this.visit(node.getLeftChild());
        Object q = this.visit(node.getRightChild());
        AndNode andNode = new AndNode(p, new DiamondNode(new VariableNode(fixedPointVar)));
        OrNode orNode = new OrNode(q, andNode);
        return new LfpNode(fixedPointVar, orNode);
    }

    @Override
    public FormulaNode<L, AP> visit(EWUNode<L, AP> node) {
        Object p = this.visit(node.getLeftChild());
        Object q = this.visit(node.getRightChild());
        EUNode until = new EUNode(p, q);
        EGNode egNode = new EGNode(this.visit(node.getLeftChild()));
        return this.visit(new OrNode(until, egNode));
    }

    @Override
    public FormulaNode<L, AP> visit(AndNode<L, AP> node) {
        Object leftChild = this.visit(node.getLeftChild());
        Object rightChild = this.visit(node.getRightChild());
        return new AndNode(leftChild, rightChild);
    }

    @Override
    public FormulaNode<L, AP> visit(AtomicNode<L, AP> node) {
        return new AtomicNode(node.getProposition());
    }

    @Override
    public FormulaNode<L, AP> visit(BoxNode<L, AP> node) {
        Object childNode = this.visit(node.getChild());
        return new BoxNode(node.getAction(), childNode);
    }

    @Override
    public FormulaNode<L, AP> visit(DiamondNode<L, AP> node) {
        Object childNode = this.visit(node.getChild());
        return new DiamondNode(node.getAction(), childNode);
    }

    @Override
    public FormulaNode<L, AP> visit(FalseNode<L, AP> node) {
        return new FalseNode();
    }

    @Override
    public FormulaNode<L, AP> visit(NotNode<L, AP> node) {
        Object childNode = this.visit(node.getChild());
        return new NotNode(childNode);
    }

    @Override
    public FormulaNode<L, AP> visit(OrNode<L, AP> node) {
        Object leftChild = this.visit(node.getLeftChild());
        Object rightChild = this.visit(node.getRightChild());
        return new OrNode(leftChild, rightChild);
    }

    @Override
    public FormulaNode<L, AP> visit(TrueNode<L, AP> node) {
        return new TrueNode();
    }

    @Override
    public FormulaNode<L, AP> visit(GfpNode<L, AP> node) {
        return new GfpNode(node.getVariable(), this.visit(node.getChild()));
    }

    @Override
    public FormulaNode<L, AP> visit(LfpNode<L, AP> node) {
        return new LfpNode(node.getVariable(), this.visit(node.getChild()));
    }

    @Override
    public FormulaNode<L, AP> visit(VariableNode<L, AP> node) {
        return new VariableNode(node.getVariable());
    }

    private String getFixedPointVar() {
        return "Z" + this.numFixedPointVars++;
    }
}

