/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.formula.visitor;

import java.util.HashSet;
import java.util.Set;
import net.automatalib.modelchecker.m3c.formula.AndNode;
import net.automatalib.modelchecker.m3c.formula.AtomicNode;
import net.automatalib.modelchecker.m3c.formula.BoxNode;
import net.automatalib.modelchecker.m3c.formula.DiamondNode;
import net.automatalib.modelchecker.m3c.formula.FalseNode;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.formula.NotNode;
import net.automatalib.modelchecker.m3c.formula.OrNode;
import net.automatalib.modelchecker.m3c.formula.TrueNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.GfpNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.LfpNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.VariableNode;

public class NNFVisitor<L, AP> {
    private Set<String> varsToNegate;

    public FormulaNode<L, AP> transformToNNF(FormulaNode<L, AP> node) {
        this.varsToNegate = new HashSet<String>();
        return this.visit(node, false);
    }

    private FormulaNode<L, AP> visit(FormulaNode<L, AP> node, boolean negate) {
        if (node instanceof GfpNode) {
            return this.visitGFPNode((GfpNode)node, negate);
        }
        if (node instanceof LfpNode) {
            return this.visitLFPNode((LfpNode)node, negate);
        }
        if (node instanceof AndNode) {
            return this.visitAndNode((AndNode)node, negate);
        }
        if (node instanceof AtomicNode) {
            return this.visitAtomicNode((AtomicNode)node, negate);
        }
        if (node instanceof BoxNode) {
            return this.visitBoxNode((BoxNode)node, negate);
        }
        if (node instanceof DiamondNode) {
            return this.visitDiamondNode((DiamondNode)node, negate);
        }
        if (node instanceof FalseNode) {
            return this.visitFalseNode(negate);
        }
        if (node instanceof VariableNode) {
            return this.visitVariableNode((VariableNode)node, negate);
        }
        if (node instanceof NotNode) {
            return this.visitNotNode((NotNode)node, negate);
        }
        if (node instanceof OrNode) {
            return this.visitOrNode((OrNode)node, negate);
        }
        if (node instanceof TrueNode) {
            return this.visitTrueNode(negate);
        }
        throw new IllegalArgumentException("Node is not a ModalMuNode");
    }

    private FormulaNode<L, AP> visitGFPNode(GfpNode<L, AP> node, boolean negate) {
        if (!negate) {
            FormulaNode childNode = this.visit(node.getChild(), false);
            return new GfpNode(node.getVariable(), childNode);
        }
        this.varsToNegate.add(node.getVariable());
        FormulaNode childNode = this.visit(node.getChild(), true);
        this.varsToNegate.remove(node.getVariable());
        return new LfpNode(node.getVariable(), childNode);
    }

    private FormulaNode<L, AP> visitLFPNode(LfpNode<L, AP> node, boolean negate) {
        if (!negate) {
            FormulaNode childNode = this.visit(node.getChild(), false);
            return new LfpNode(node.getVariable(), childNode);
        }
        this.varsToNegate.add(node.getVariable());
        FormulaNode childNode = this.visit(node.getChild(), true);
        this.varsToNegate.remove(node.getVariable());
        return new GfpNode(node.getVariable(), childNode);
    }

    private FormulaNode<L, AP> visitAndNode(AndNode<L, AP> node, boolean negate) {
        FormulaNode leftChild = this.visit(node.getLeftChild(), negate);
        FormulaNode rightChild = this.visit(node.getRightChild(), negate);
        return negate ? new OrNode(leftChild, rightChild) : new AndNode(leftChild, rightChild);
    }

    private FormulaNode<L, AP> visitAtomicNode(AtomicNode<L, AP> node, boolean negate) {
        AtomicNode newNode = new AtomicNode(node.getProposition());
        return negate ? new NotNode(newNode) : newNode;
    }

    private FormulaNode<L, AP> visitBoxNode(BoxNode<L, AP> node, boolean negate) {
        FormulaNode childNode = this.visit(node.getChild(), negate);
        Object action = node.getAction();
        return negate ? new DiamondNode(action, childNode) : new BoxNode(action, childNode);
    }

    private FormulaNode<L, AP> visitDiamondNode(DiamondNode<L, AP> node, boolean negate) {
        FormulaNode childNode = this.visit(node.getChild(), negate);
        Object action = node.getAction();
        return negate ? new BoxNode(action, childNode) : new DiamondNode(action, childNode);
    }

    private FormulaNode<L, AP> visitFalseNode(boolean negate) {
        return negate ? new TrueNode() : new FalseNode();
    }

    private FormulaNode<L, AP> visitVariableNode(VariableNode<L, AP> node, boolean negate) {
        VariableNode newNode = new VariableNode(node.getVariable());
        boolean negateVariable = negate ^ this.varsToNegate.contains(node.getVariable());
        return negateVariable ? new NotNode(newNode) : newNode;
    }

    private FormulaNode<L, AP> visitNotNode(NotNode<L, AP> node, boolean negate) {
        return this.visit(node.getChild(), !negate);
    }

    private FormulaNode<L, AP> visitOrNode(OrNode<L, AP> node, boolean negate) {
        FormulaNode leftChild = this.visit(node.getLeftChild(), negate);
        FormulaNode rightChild = this.visit(node.getRightChild(), negate);
        return negate ? new AndNode(leftChild, rightChild) : new OrNode(leftChild, rightChild);
    }

    private FormulaNode<L, AP> visitTrueNode(boolean negate) {
        return negate ? new FalseNode() : new TrueNode();
    }
}

