/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.solver;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.common.util.mapping.Mappings;
import net.automatalib.graph.ProceduralModalProcessGraph;
import net.automatalib.graph.concept.NodeIDs;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.transformer.AbstractPropertyTransformer;
import net.automatalib.modelchecker.m3c.transformer.TransformerSerializer;

public final class SolverData<N, T extends AbstractPropertyTransformer<T, L, AP>, L, AP> {
    private final ProceduralModalProcessGraph<N, L, ?, AP, ?> pmpg;
    private final NodeIDs<N> nodeIDs;
    private final Mapping<N, List<String>> initialPropertyTransformers;
    private final Mapping<N, List<FormulaNode<L, AP>>> initialSatisfiedSubformulas;

    SolverData(ProceduralModalProcessGraph<N, L, ?, AP, ?> pmpg, Mapping<N, List<String>> initialPropertyTransformers, Mapping<N, List<FormulaNode<L, AP>>> initialSatisfiedSubformulas) {
        this.pmpg = pmpg;
        this.nodeIDs = pmpg.nodeIDs();
        this.initialPropertyTransformers = initialPropertyTransformers;
        this.initialSatisfiedSubformulas = initialSatisfiedSubformulas;
    }

    public ProceduralModalProcessGraph<N, L, ?, AP, ?> getPmpg() {
        return this.pmpg;
    }

    public NodeIDs<N> getNodeIDs() {
        return this.nodeIDs;
    }

    public Mapping<N, T> getInitialPropertyTransformers(TransformerSerializer<T, L, AP> serializer) {
        HashMap result = Maps.newHashMapWithExpectedSize(this.pmpg.size());
        for (Object n : this.pmpg) {
            result.put(n, serializer.deserialize(this.initialPropertyTransformers.get(n)));
        }
        return Mappings.fromMap(result);
    }

    public Mapping<N, List<FormulaNode<L, AP>>> getInitialSatisfiedSubformulas() {
        return this.initialSatisfiedSubformulas;
    }
}

