/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.visualization;

import java.util.Map;
import java.util.Objects;
import net.automatalib.graph.base.CompactEdge;
import net.automatalib.modelchecker.m3c.solver.WitnessTree;
import net.automatalib.visualization.DefaultVisualizationHelper;

abstract class AbstractVisualizationHelper
extends DefaultVisualizationHelper<Integer, CompactEdge<String>> {
    protected final WitnessTree<?, ?> resultTree;

    AbstractVisualizationHelper(WitnessTree<?, ?> resultTree) {
        this.resultTree = resultTree;
    }

    @Override
    public boolean getNodeProperties(Integer node, Map<String, String> properties) {
        super.getNodeProperties(node, properties);
        properties.put("shape", "box");
        properties.put("label", Objects.toString(this.resultTree.getNodeProperty(node)));
        return true;
    }

    @Override
    public boolean getEdgeProperties(Integer src, CompactEdge<String> edge, Integer tgt, Map<String, String> properties) {
        super.getEdgeProperties(src, edge, tgt, properties);
        properties.put("arrowhead", "none");
        properties.put("label", Objects.toString(edge.getProperty()));
        return true;
    }
}

