/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.fsm.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import net.automatalib.automaton.concept.Output;
import net.automatalib.common.util.Pair;
import net.automatalib.serialization.fsm.parser.AbstractFSM2MealyParser;
import net.automatalib.serialization.fsm.parser.FSMFormatException;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FSM2MealyParserAlternating<I, O>
extends AbstractFSM2MealyParser<I, O> {
    public static final String PARTIAL_FSM = "FSM transition relation is incomplete: could not reach states '%s', from initial state '%s'";
    public static final String INPUT_HAS_NO_OUTPUT = "FSM input '%s' at state '%d' has no corresponding output";
    private final Multimap<Integer, Pair<String, Integer>> transitionsFSM = ArrayListMultimap.create();
    private final @Nullable Output<I, Word<O>> output;

    private FSM2MealyParserAlternating(@Nullable Collection<? extends I> targetInputs, @Nullable Output<I, Word<O>> output, Function<String, I> inputParser, Function<String, O> outputParser) {
        super(targetInputs, inputParser, outputParser);
        this.output = output;
    }

    @Override
    protected void parseTransition(StreamTokenizer streamTokenizer) throws IOException {
        try {
            if (streamTokenizer.nextToken() != -3) {
                throw new FSMFormatException("number expected", streamTokenizer);
            }
            int from = Integer.parseInt(streamTokenizer.sval);
            if (!this.getStates().isEmpty() && !this.getStates().contains(from)) {
                throw new FSMFormatException(String.format("state with number %d is undefined", from), streamTokenizer);
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new FSMFormatException("number expected", streamTokenizer);
            }
            int to = Integer.parseInt(streamTokenizer.sval);
            if (!this.getStates().isEmpty() && !this.getStates().contains(to)) {
                throw new FSMFormatException(String.format("state with number %d is undefined", to), streamTokenizer);
            }
            if (streamTokenizer.nextToken() != 34) {
                throw new FSMFormatException("expecting string", streamTokenizer);
            }
            String letter = streamTokenizer.sval;
            boolean isNew = this.transitionsFSM.put(from, Pair.of(letter, to));
            if (!isNew) {
                throw new FSMFormatException(String.format("non-determinism detected (previous value: %s)", from), streamTokenizer);
            }
        }
        catch (NumberFormatException | NoSuchElementException e) {
            throw new FSMFormatException(e, streamTokenizer);
        }
    }

    private void makeTransitions(Integer currentState, @Nullable Pair<Integer, I> inputTrans, Set<Integer> newStates, int inputLength, @Nullable WordBuilder<I> wb, StreamTokenizer streamTokenizer) {
        newStates.remove(currentState);
        Collection<Pair<String, Integer>> targets = this.transitionsFSM.get(currentState);
        if (inputTrans != null && targets.isEmpty()) {
            if (wb != null) {
                assert (this.output != null);
                O o = this.output.computeOutput(wb).lastSymbol();
                Pair<O, Integer> prev = this.getTransitions().put(inputTrans, Pair.of(o, this.getStates().size()));
                if (prev != null) {
                    throw new FSMFormatException(String.format("non-determinism detected (previous value: %s)", prev), streamTokenizer);
                }
            } else {
                throw new FSMFormatException(String.format(INPUT_HAS_NO_OUTPUT, inputTrans.getSecond(), inputTrans.getFirst()), streamTokenizer);
            }
        }
        for (Pair<String, Integer> target : targets) {
            String letter = target.getFirst();
            Integer to = target.getSecond();
            if (inputTrans == null) {
                Object i = this.getInputParser().apply(letter);
                this.getInputs().add(i);
                if (wb != null) {
                    assert (wb.size() == inputLength);
                    wb.append(i);
                }
                this.makeTransitions(to, Pair.of(currentState, i), newStates, inputLength + 1, wb, streamTokenizer);
                if (wb == null) continue;
                assert (wb.size() > inputLength);
                wb.truncate(inputLength);
                continue;
            }
            Object o = this.getOutputParser().apply(letter);
            Pair prev = this.getTransitions().put(inputTrans, Pair.of(o, to));
            if (prev != null) {
                throw new FSMFormatException(String.format("non-determinism detected (previous value: %s)", prev), streamTokenizer);
            }
            if (!newStates.contains(to)) continue;
            this.makeTransitions(to, null, newStates, inputLength, wb, streamTokenizer);
        }
    }

    @Override
    protected void checkTransitions(StreamTokenizer streamTokenizer) {
        if (this.getStates().isEmpty()) {
            this.getStates().addAll(this.transitionsFSM.keySet());
        }
        HashSet<Integer> newStates = new HashSet<Integer>(this.getStates());
        Integer initialState = (Integer)this.getStates().iterator().next();
        this.makeTransitions(initialState, null, newStates, 0, this.output != null ? new WordBuilder() : null, streamTokenizer);
        if (!newStates.isEmpty()) {
            throw new FSMFormatException(String.format(PARTIAL_FSM, newStates, initialState), streamTokenizer);
        }
    }

    public static <I, O> FSM2MealyParserAlternating<I, O> getParser(@Nullable Collection<? extends I> targetInputs, @Nullable Output<I, Word<O>> output, Function<String, I> inputParser, Function<String, O> outputParser) {
        return new FSM2MealyParserAlternating<I, O>(targetInputs, output, inputParser, outputParser);
    }

    public static <I, O> FSM2MealyParserAlternating<I, O> getParser(Function<String, I> inputParser, Function<String, O> outputParser) {
        return FSM2MealyParserAlternating.getParser(null, null, inputParser, outputParser);
    }

    public static <E> FSM2MealyParserAlternating<E, E> getParser(@Nullable Collection<? extends E> targetInputs, @Nullable Output<E, Word<E>> output, Function<String, E> edgeParser) {
        return FSM2MealyParserAlternating.getParser(targetInputs, output, edgeParser, edgeParser);
    }

    public static <E> FSM2MealyParserAlternating<E, E> getParser(Function<String, E> edgeParser) {
        return FSM2MealyParserAlternating.getParser(edgeParser, edgeParser);
    }
}

