/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.ads;

import java.util.Collections;
import java.util.Set;
import net.automatalib.util.automaton.ads.SplitTree;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

class SplitTreeResult<S, I, O> {
    private final @Nullable SplitTree<S, I, O> delegate;
    private final Set<S> indistinguishableStates;

    SplitTreeResult(SplitTree<S, I, O> result) {
        this.delegate = result;
        this.indistinguishableStates = Collections.emptySet();
    }

    SplitTreeResult(Set<S> indistinguishableStates) {
        this.delegate = null;
        this.indistinguishableStates = indistinguishableStates;
    }

    @EnsuresNonNullIf(expression={"this.delegate"}, result=true)
    public boolean isPresent() {
        return this.delegate != null;
    }

    public @Nullable SplitTree<S, I, O> get() {
        return this.delegate;
    }

    public Set<S> getIndistinguishableStates() {
        return this.indistinguishableStates;
    }
}

