/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.conformance;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.conformance.StrictPriorityQueue;
import net.automatalib.util.automaton.cover.Covers;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IncrementalWMethodTestsIterator<I>
implements Iterator<Word<I>> {
    private final Alphabet<I> alphabet;
    private final StrictPriorityQueue<Item<I>> itemQueue;
    private final List<Word<I>> prefixes = new ArrayList<Word<I>>();
    private final List<Word<I>> suffixes = new ArrayList<Word<I>>();
    private int maxDepth;

    public IncrementalWMethodTestsIterator(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.itemQueue = new StrictPriorityQueue<I>(new ItemComparator<I>(alphabet), new ItemMerge());
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void update(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton) {
        Item item;
        int oldNumPrefixes = this.prefixes.size();
        boolean newPrefixes = Covers.incrementalTransitionCover(automaton, this.alphabet, this.prefixes, this.prefixes);
        int oldNumSuffixes = this.suffixes.size();
        boolean newSuffixes = Automata.incrementalCharacterizingSet(automaton, this.alphabet, this.suffixes, this.suffixes);
        if (newSuffixes && oldNumPrefixes > 0) {
            item = new Item();
            item.prefixIdx = 0;
            item.minPrefix = 0;
            item.maxPrefix = oldNumPrefixes;
            item.suffixIdx = oldNumSuffixes;
            item.minSuffix = oldNumSuffixes;
            item.middle = Word.epsilon();
            this.itemQueue.offer(item);
        }
        if (newPrefixes) {
            item = new Item();
            item.prefixIdx = oldNumPrefixes;
            item.minPrefix = oldNumPrefixes;
            item.maxPrefix = this.prefixes.size();
            item.suffixIdx = 0;
            item.minSuffix = 0;
            item.middle = Word.epsilon();
            this.itemQueue.offer(item);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.itemQueue.isEmpty();
    }

    @Override
    public Word<I> next() {
        Item nextItem = (Item)this.itemQueue.remove();
        Word<I> result = this.assembleWord(nextItem);
        @Nullable Item<I> inc = this.increment(nextItem);
        if (inc != null) {
            this.itemQueue.offer(inc);
        }
        return result;
    }

    private Word<I> assembleWord(Item<I> item) {
        Word<I> prefix = this.prefixes.get(((Item)item).prefixIdx);
        if (this.suffixes.isEmpty()) {
            return prefix.concat(((Item)item).middle);
        }
        return prefix.concat(((Item)item).middle, this.suffixes.get(((Item)item).suffixIdx));
    }

    private @Nullable Item<I> increment(Item<I> item) {
        ((Item)item).suffixIdx++;
        if (((Item)item).suffixIdx >= this.suffixes.size()) {
            ((Item)item).suffixIdx = ((Item)item).minSuffix;
            ((Item)item).prefixIdx++;
            if (((Item)item).prefixIdx >= ((Item)item).maxPrefix) {
                ((Item)item).prefixIdx = ((Item)item).minPrefix;
                ((Item)item).middle = ((Item)item).middle.canonicalNext(this.alphabet);
                if (((Item)item).middle.length() > this.maxDepth) {
                    return null;
                }
            }
        }
        return item;
    }

    private static final class ItemComparator<I>
    implements Comparator<Item<I>> {
        private final Comparator<Word<I>> canonicalCmp;

        ItemComparator(Comparator<? super I> symComparator) {
            this.canonicalCmp = Word.canonicalComparator(symComparator);
        }

        @Override
        public int compare(Item<I> o1, Item<I> o2) {
            int cmp = this.canonicalCmp.compare(((Item)o1).middle, ((Item)o2).middle);
            if (cmp != 0) {
                return cmp;
            }
            cmp = ((Item)o1).prefixIdx - ((Item)o2).prefixIdx;
            if (cmp != 0) {
                return cmp;
            }
            return ((Item)o1).suffixIdx - ((Item)o2).suffixIdx;
        }
    }

    private static final class ItemMerge<I>
    implements StrictPriorityQueue.MergeOperation<Item<I>> {
        private ItemMerge() {
        }

        @Override
        public Item<I> merge(Item<I> oldObject, Item<I> newObject) {
            ((Item)oldObject).minSuffix = Math.min(((Item)oldObject).minSuffix, ((Item)newObject).minSuffix);
            ((Item)oldObject).minPrefix = Math.min(((Item)oldObject).minPrefix, ((Item)newObject).minPrefix);
            ((Item)oldObject).maxPrefix = Math.max(((Item)oldObject).maxPrefix, ((Item)newObject).maxPrefix);
            return oldObject;
        }
    }

    private static final class Item<I> {
        private int prefixIdx;
        private int suffixIdx;
        private Word<I> middle;
        private int minSuffix;
        private int minPrefix;
        private int maxPrefix;

        private Item() {
        }
    }
}

