/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.copy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import net.automatalib.automaton.Automaton;
import net.automatalib.automaton.MutableAutomaton;
import net.automatalib.ts.TransitionPredicate;
import net.automatalib.util.automaton.copy.AbstractLowLevelAutomatonCopier;

final class PlainAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2>
extends AbstractLowLevelAutomatonCopier<S1, I1, T1, S2, I2, T2, SP2, TP2, Automaton<S1, ? super I1, T1>> {
    PlainAutomatonCopy(Automaton<S1, ? super I1, T1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, T2, ? super SP2, ? super TP2> out, Function<? super I1, ? extends I2> inputsMapping, Function<? super S1, ? extends SP2> spMapping, Function<? super T1, ? extends TP2> tpMapping, Predicate<? super S1> stateFilter, TransitionPredicate<? super S1, ? super I1, ? super T1> transFilter) {
        super(in, inputs, out, inputsMapping, spMapping, tpMapping, stateFilter, transFilter);
    }

    @Override
    public void doCopy() {
        ArrayList outStates = new ArrayList(((Automaton)this.in).size());
        for (Object s2 : (Automaton)this.in) {
            if (!this.stateFilter.test(s2)) continue;
            Object s22 = this.copyState(s2);
            outStates.add(new StateRec(s2, s22));
        }
        for (StateRec stateRec : outStates) {
            Object s1 = stateRec.inState;
            Object s2 = stateRec.outState;
            for (Object i1 : this.inputs) {
                Object i2 = this.inputsMapping.apply(i1);
                Collection transitions1 = ((Automaton)this.in).getTransitions(s1, i1);
                this.copyTransitions(s2, i2, transitions1.stream().filter(t -> this.transFilter.apply(s1, i1, t)).iterator());
            }
        }
        this.updateInitials();
    }

    private static class StateRec<S1, S2> {
        private final S1 inState;
        private final S2 outState;

        StateRec(S1 inState, S2 outState) {
            this.inState = inState;
            this.outState = outState;
        }
    }
}

