/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.equivalence;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.DeterministicAutomaton;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.concept.InputAlphabetHolder;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.common.util.UnionFindRemSP;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NearLinearEquivalenceTest {
    private NearLinearEquivalenceTest() {
    }

    public static <S, I> @Nullable Word<I> findSeparatingWord(UniversalDeterministicAutomaton<S, I, ?, ?, ?> target, S init1, S init2, Collection<? extends I> inputs) {
        return NearLinearEquivalenceTest.findSeparatingWord(target, init1, init2, inputs, false);
    }

    public static <S, I, T> @Nullable Word<I> findSeparatingWord(UniversalDeterministicAutomaton<S, I, T, ?, ?> target, S init1, S init2, Collection<? extends I> inputs, boolean ignoreUndefinedTransitions) {
        Record current;
        Object sprop2;
        Object sprop1 = target.getStateProperty(init1);
        if (!Objects.equals(sprop1, sprop2 = target.getStateProperty(init2))) {
            return Word.epsilon();
        }
        UnionFindRemSP uf = new UnionFindRemSP(target.size());
        StateIDs stateIds = target.stateIDs();
        int id1 = stateIds.getStateId(init1);
        int id2 = stateIds.getStateId(init2);
        uf.link(id1, id2);
        ArrayDeque queue = new ArrayDeque();
        queue.add(new Record(init1, init2));
        Object lastSym = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            Object state1 = current.state1;
            Object state2 = current.state2;
            for (I sym : inputs) {
                int r2;
                Object tprop2;
                Object trans1 = target.getTransition(state1, sym);
                Object trans2 = target.getTransition(state2, sym);
                if (ignoreUndefinedTransitions && (trans1 == null || trans2 == null)) continue;
                if (trans1 == null) {
                    if (trans2 == null) continue;
                    lastSym = sym;
                    break block0;
                }
                if (trans2 == null) {
                    lastSym = sym;
                    break block0;
                }
                Object tprop1 = target.getTransitionProperty(trans1);
                if (!Objects.equals(tprop1, tprop2 = target.getTransitionProperty(trans2))) {
                    lastSym = sym;
                    break block0;
                }
                Object succ1 = target.getSuccessor(trans1);
                Object succ2 = target.getSuccessor(trans2);
                id1 = stateIds.getStateId(succ1);
                id2 = stateIds.getStateId(succ2);
                int r1 = uf.find(id1);
                if (r1 == (r2 = uf.find(id2))) continue;
                sprop1 = target.getStateProperty(succ1);
                if (!Objects.equals(sprop1, sprop2 = target.getStateProperty(succ2))) {
                    lastSym = sym;
                    break block0;
                }
                uf.link(r1, r2);
                queue.add(new Record(succ1, succ2, sym, current));
            }
        }
        if (current == null) {
            return null;
        }
        int position = current.depth + 1;
        WordBuilder<Object> wb = new WordBuilder<Object>(null, position);
        wb.setSymbol(--position, lastSym);
        while (current.reachedFrom != null) {
            wb.setSymbol(--position, current.reachedBy);
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    public static <I> @Nullable Word<I> findSeparatingWord(UniversalDeterministicAutomaton<?, I, ?, ?, ?> target, UniversalDeterministicAutomaton<?, I, ?, ?, ?> other, Collection<? extends I> inputs) {
        return NearLinearEquivalenceTest.findSeparatingWord(target, other, inputs, false);
    }

    public static <S, S2, I, T, T2, SP, SP2, TP, TP2> @Nullable Word<I> findSeparatingWord(UniversalDeterministicAutomaton<S, I, T, SP, TP> target, UniversalDeterministicAutomaton<S2, I, T2, SP2, TP2> other, Collection<? extends I> inputs, boolean ignoreUndefinedTransitions) {
        Record current;
        Object sprop2;
        Alphabet otherAlphabet;
        Alphabet targetAlphabet;
        Alphabet alphabet;
        if (inputs instanceof Alphabet && target instanceof InputAlphabetHolder && other instanceof InputAlphabetHolder && (alphabet = (Alphabet)inputs).equals(targetAlphabet = ((InputAlphabetHolder)((Object)target)).getInputAlphabet()) && alphabet.equals(otherAlphabet = ((InputAlphabetHolder)((Object)other)).getInputAlphabet())) {
            return NearLinearEquivalenceTest.findSeparatingWord(target, other, alphabet, ignoreUndefinedTransitions);
        }
        Object init1 = target.getInitialState();
        Object init2 = other.getInitialState();
        if (init1 == null && init2 == null) {
            return null;
        }
        if (init1 == null || init2 == null) {
            return ignoreUndefinedTransitions ? null : Word.epsilon();
        }
        Object sprop1 = target.getStateProperty(init1);
        if (!Objects.equals(sprop1, sprop2 = other.getStateProperty(init2))) {
            return Word.epsilon();
        }
        int targetStates = target.size();
        UnionFindRemSP uf = new UnionFindRemSP(targetStates + other.size());
        StateIDs targetStateIds = target.stateIDs();
        StateIDs otherStateIds = other.stateIDs();
        int id1 = targetStateIds.getStateId(init1);
        int id2 = otherStateIds.getStateId(init2) + targetStates;
        uf.link(id1, id2);
        ArrayDeque queue = new ArrayDeque();
        queue.add(new Record(init1, init2));
        Object lastSym = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            Object state1 = current.state1;
            Object state2 = current.state2;
            for (I sym : inputs) {
                Object tprop2;
                Object trans1 = target.getTransition(state1, sym);
                Object trans2 = other.getTransition(state2, sym);
                if (ignoreUndefinedTransitions && (trans1 == null || trans2 == null)) continue;
                if (trans1 == null) {
                    if (trans2 == null) continue;
                    lastSym = sym;
                    break block0;
                }
                if (trans2 == null) {
                    lastSym = sym;
                    break block0;
                }
                Object tprop1 = target.getTransitionProperty(trans1);
                if (!Objects.equals(tprop1, tprop2 = other.getTransitionProperty(trans2))) {
                    lastSym = sym;
                    break block0;
                }
                Object succ1 = target.getSuccessor(trans1);
                Object succ2 = other.getSuccessor(trans2);
                id1 = targetStateIds.getStateId(succ1);
                if (!uf.union(id1, id2 = otherStateIds.getStateId(succ2) + targetStates)) continue;
                sprop1 = target.getStateProperty(succ1);
                if (!Objects.equals(sprop1, sprop2 = other.getStateProperty(succ2))) {
                    lastSym = sym;
                    break block0;
                }
                queue.add(new Record(succ1, succ2, sym, current));
            }
        }
        if (current == null) {
            return null;
        }
        int position = current.depth + 1;
        WordBuilder<Object> wb = new WordBuilder<Object>(null, position);
        wb.setSymbol(--position, lastSym);
        while (current.reachedFrom != null) {
            wb.setSymbol(--position, current.reachedBy);
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    public static <I> @Nullable Word<I> findSeparatingWord(UniversalDeterministicAutomaton<?, I, ?, ?, ?> target, UniversalDeterministicAutomaton<?, I, ?, ?, ?> other, Alphabet<I> inputs) {
        return NearLinearEquivalenceTest.findSeparatingWord(target, other, inputs, false);
    }

    public static <S, S2, I, T, T2, SP, SP2, TP, TP2> @Nullable Word<I> findSeparatingWord(UniversalDeterministicAutomaton<S, I, T, SP, TP> target, UniversalDeterministicAutomaton<S2, I, T2, SP2, TP2> other, Alphabet<I> inputs, boolean ignoreUndefinedTransitions) {
        IntRecord current;
        Object sprop2;
        DeterministicAutomaton.FullIntAbstraction absTarget = target.fullIntAbstraction((Alphabet)inputs);
        DeterministicAutomaton.FullIntAbstraction absOther = other.fullIntAbstraction((Alphabet)inputs);
        int init1 = absTarget.getIntInitialState();
        int init2 = absOther.getIntInitialState();
        if (init1 < 0 && init2 < 0) {
            return null;
        }
        if (init1 < 0 || init2 < 0) {
            return ignoreUndefinedTransitions ? null : Word.epsilon();
        }
        Object sprop1 = absTarget.getStateProperty(init1);
        if (!Objects.equals(sprop1, sprop2 = absOther.getStateProperty(init2))) {
            return Word.epsilon();
        }
        int targetStates = target.size();
        UnionFindRemSP uf = new UnionFindRemSP(targetStates + other.size());
        int id1 = init1;
        int id2 = targetStates + init2;
        uf.link(id1, id2);
        ArrayDeque<IntRecord> queue = new ArrayDeque<IntRecord>();
        queue.add(new IntRecord(init1, init2));
        int lastSym = -1;
        int numInputs = inputs.size();
        block0: while ((current = (IntRecord)queue.poll()) != null) {
            int state1 = current.state1;
            int state2 = current.state2;
            for (int sym = 0; sym < numInputs; ++sym) {
                int succ2;
                Object tprop2;
                Object trans1 = absTarget.getTransition(state1, sym);
                Object trans2 = absOther.getTransition(state2, sym);
                if (ignoreUndefinedTransitions && (trans1 == null || trans2 == null)) continue;
                if (trans1 == null) {
                    if (trans2 == null) continue;
                    lastSym = sym;
                    break block0;
                }
                if (trans2 == null) {
                    lastSym = sym;
                    break block0;
                }
                Object tprop1 = target.getTransitionProperty(trans1);
                if (!Objects.equals(tprop1, tprop2 = other.getTransitionProperty(trans2))) {
                    lastSym = sym;
                    break block0;
                }
                int succ1 = absTarget.getIntSuccessor(trans1);
                id1 = succ1;
                if (!uf.union(id1, id2 = (succ2 = absOther.getIntSuccessor(trans2)) + targetStates)) continue;
                sprop1 = absTarget.getStateProperty(succ1);
                if (!Objects.equals(sprop1, sprop2 = absOther.getStateProperty(succ2))) {
                    lastSym = sym;
                    break block0;
                }
                queue.add(new IntRecord(succ1, succ2, sym, current));
            }
        }
        if (current == null) {
            return null;
        }
        int position = current.depth + 1;
        WordBuilder<Object> wb = new WordBuilder<Object>(null, position);
        wb.setSymbol(--position, inputs.getSymbol(lastSym));
        while (current.reachedFrom != null) {
            wb.setSymbol(--position, inputs.getSymbol(current.reachedBy));
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    private static final class IntRecord {
        private final int state1;
        private final int state2;
        private final int reachedBy;
        private final @Nullable IntRecord reachedFrom;
        private final int depth;

        IntRecord(int state1, int state2) {
            this(state1, state2, -1, null);
        }

        IntRecord(int state1, int state2, int reachedBy, @Nullable IntRecord reachedFrom) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedBy = reachedBy;
            this.reachedFrom = reachedFrom;
            this.depth = reachedFrom != null ? reachedFrom.depth + 1 : 0;
        }
    }

    private static final class Record<S, S2, I> {
        private final S state1;
        private final S2 state2;
        private final I reachedBy;
        private final @Nullable Record<S, S2, I> reachedFrom;
        private final int depth;

        Record(S state1, S2 state2) {
            this(state1, state2, null, null);
        }

        Record(S state1, S2 state2, I reachedBy, @Nullable Record<S, S2, I> reachedFrom) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedBy = reachedBy;
            this.reachedFrom = reachedFrom;
            this.depth = reachedFrom != null ? reachedFrom.depth + 1 : 0;
        }
    }
}

