/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.transducer;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.automatalib.automaton.transducer.MutableSubsequentialTransducer;
import net.automatalib.automaton.transducer.SubsequentialTransducer;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.copy.AutomatonCopyMethod;
import net.automatalib.util.automaton.copy.AutomatonLowLevelCopy;
import net.automatalib.word.Word;

public final class SubsequentialTransducers {
    private SubsequentialTransducers() {
    }

    public static <S1, S2, I, T1, T2, O, A extends MutableSubsequentialTransducer<S2, I, T2, O>> A toOnwardSST(SubsequentialTransducer<S1, I, T1, O> sst, Collection<? extends I> inputs, A out) {
        return SubsequentialTransducers.toOnwardSST(sst, inputs, out, true);
    }

    public static <S1, S2, I, T1, T2, O, A extends MutableSubsequentialTransducer<S2, I, T2, O>> A toOnwardSST(SubsequentialTransducer<S1, I, T1, O> sst, Collection<? extends I> inputs, A out, boolean minimize) {
        assert (out.size() == 0);
        AutomatonLowLevelCopy.copy(AutomatonCopyMethod.STATE_BY_STATE, sst, inputs, out);
        Mapping incomingTransitions = SubsequentialTransducers.getIncomingTransitions(out, inputs);
        ArrayDeque queue = new ArrayDeque(out.getStates());
        Object oldInit = out.getInitialState();
        if (oldInit != null && !incomingTransitions.get(oldInit).isEmpty()) {
            out.setInitial(oldInit, false);
            Object newInit = out.addInitialState((Word)((Word)out.getStateProperty(oldInit)));
            for (I i : inputs) {
                Object oldT = out.getTransition(oldInit, i);
                if (oldT == null) continue;
                Object succ = out.getSuccessor(oldT);
                out.addTransition(newInit, i, succ, (Word)((Word)out.getTransitionProperty(oldT)));
                incomingTransitions.get(succ).add(Pair.of(newInit, i));
            }
        }
        while (!queue.isEmpty()) {
            Word<O> lcp;
            Object s2 = queue.pop();
            if (Objects.equals(s2, out.getInitialState()) || (lcp = SubsequentialTransducers.computeLCP(out, inputs, s2)).isEmpty()) continue;
            Word oldStateProperty = (Word)out.getStateProperty(s2);
            Word newStateProperty = oldStateProperty.subWord(lcp.length());
            out.setStateProperty(s2, newStateProperty);
            for (I i : inputs) {
                Object t = out.getTransition(s2, i);
                if (t == null) continue;
                Word oldTransitionProperty = (Word)out.getTransitionProperty(t);
                Word newTransitionProperty = oldTransitionProperty.subWord(lcp.length());
                out.setTransitionProperty(t, newTransitionProperty);
            }
            for (Pair pair : incomingTransitions.get(s2)) {
                Object src = pair.getFirst();
                Object t = out.getTransition(src, pair.getSecond());
                assert (t != null);
                Word oldTransitionProperty = (Word)out.getTransitionProperty(t);
                Word newTransitionProperty = oldTransitionProperty.concat(lcp);
                out.setTransitionProperty(t, newTransitionProperty);
                if (queue.contains(src)) continue;
                queue.add(src);
            }
        }
        return minimize ? Automata.invasiveMinimize(out, inputs) : out;
    }

    public static <S, I, T, O> boolean isOnwardSST(SubsequentialTransducer<S, I, T, O> sst, Collection<? extends I> inputs) {
        for (Object s2 : sst) {
            Word<O> lcp;
            if (Objects.equals(s2, sst.getInitialState()) || (lcp = SubsequentialTransducers.computeLCP(sst, inputs, s2)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static <S, I, T> Mapping<S, Set<Pair<S, I>>> getIncomingTransitions(SubsequentialTransducer<S, I, T, ?> sst, Collection<? extends I> inputs) {
        MutableMapping result = sst.createStaticStateMapping();
        for (Object s2 : sst) {
            result.put(s2, new HashSet());
        }
        for (Object s2 : sst) {
            for (I i : inputs) {
                Object t = sst.getTransition(s2, i);
                if (t == null) continue;
                Object succ = sst.getSuccessor(t);
                ((Set)result.get(succ)).add(Pair.of(s2, i));
            }
        }
        return result;
    }

    private static <S, I, T, O> Word<O> computeLCP(SubsequentialTransducer<S, I, T, O> sst, Collection<? extends I> inputs, S s2) {
        Word lcp = (Word)sst.getStateProperty(s2);
        for (I i : inputs) {
            Object t = sst.getTransition(s2, i);
            if (t == null) continue;
            lcp = lcp.longestCommonPrefix((Word)sst.getTransitionProperty(t));
        }
        return lcp;
    }
}

