/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.vpa;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.DefaultProceduralInputAlphabet;
import net.automatalib.alphabet.GrowingMapAlphabet;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.procedural.SPA;
import net.automatalib.automaton.procedural.StackSPA;
import net.automatalib.automaton.vpa.OneSEVPA;
import net.automatalib.common.smartcollection.ArrayStorage;
import net.automatalib.common.util.Pair;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.fsa.MutableDFAs;
import net.automatalib.util.automaton.procedural.ATRSequences;
import net.automatalib.util.automaton.procedural.SPAs;
import net.automatalib.util.automaton.vpa.OneSEVPAs;
import net.automatalib.util.automaton.vpa.SymbolMapper;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

final class SPAConverter {
    private SPAConverter() {
    }

    public static <L, AI, CI> ConversionResult<AI, CI> convert(OneSEVPA<L, AI> sevpa, VPAlphabet<AI> alphabet, CI mainProcedure, SymbolMapper<AI, CI> symbolMapper, boolean minimize) {
        if (alphabet.getNumReturns() != 1) {
            throw new IllegalArgumentException("Currently only single return symbols are supported.");
        }
        HashMap procedureMap = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
        HashMap<CI, Object> reverseMapping = new HashMap<CI, Object>();
        GrowingMapAlphabet<CI> callAlphabet = new GrowingMapAlphabet<CI>();
        GrowingMapAlphabet<CI> intAlphabet = new GrowingMapAlphabet<CI>();
        callAlphabet.addSymbol(mainProcedure);
        for (Object ai : alphabet.getCallAlphabet()) {
            HashMap locationMap = Maps.newHashMapWithExpectedSize(sevpa.size());
            for (Object l : sevpa.getLocations()) {
                CI cc = symbolMapper.mapCallSymbol(ai);
                locationMap.put(l, cc);
                callAlphabet.addSymbol(cc);
                reverseMapping.put(cc, ai);
            }
            procedureMap.put(ai, locationMap);
        }
        for (Object ai : alphabet.getInternalAlphabet()) {
            CI ci = symbolMapper.mapInternalSymbol(ai);
            intAlphabet.addSymbol(ci);
            reverseMapping.put(ci, ai);
        }
        AI aRet = alphabet.getReturnSymbol(0);
        CI cRet = symbolMapper.mapReturnSymbol(aRet);
        reverseMapping.put(cRet, aRet);
        DefaultProceduralInputAlphabet spaAlphabet = new DefaultProceduralInputAlphabet(intAlphabet, callAlphabet, cRet);
        HashMap procedures = Maps.newHashMapWithExpectedSize(callAlphabet.size() * sevpa.size());
        HashMap l2sMap = Maps.newHashMapWithExpectedSize(sevpa.size());
        CompactDFA template = SPAConverter.buildTemplate(sevpa, alphabet, spaAlphabet, symbolMapper, procedureMap, l2sMap);
        for (Object l : sevpa.getLocations()) {
            CompactDFA lCopy = new CompactDFA(template);
            lCopy.setAccepting((Integer)l2sMap.get(l), true);
            for (Object ai : alphabet.getCallAlphabet()) {
                Object ci = ((Map)procedureMap.get(ai)).get(l);
                procedures.put(ci, lCopy);
            }
        }
        CompactDFA mCopy = new CompactDFA(template);
        for (Object l : sevpa.getLocations()) {
            if (!sevpa.isAcceptingLocation(l)) continue;
            mCopy.setAccepting((Integer)l2sMap.get(l), true);
        }
        procedures.put(mainProcedure, mCopy);
        HashMap dts = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
        Collection<Pair<Word<AI>, Word<AI>>> cs = OneSEVPAs.findCharacterizingSet(sevpa, alphabet);
        ArrayStorage<Word<AI>> as = OneSEVPAs.computeAccessSequences(sevpa, alphabet);
        StackSPA spa = new StackSPA(spaAlphabet, mainProcedure, procedures);
        if (minimize) {
            ATRSequences atr = SPAs.computeATRSequences(spa);
            Set accessibleProcedures = atr.accessSequences.keySet();
            DefaultProceduralInputAlphabet minimizedAlphabet = new DefaultProceduralInputAlphabet(spaAlphabet.getInternalAlphabet(), Alphabets.fromCollection(accessibleProcedures), spaAlphabet.getReturnSymbol());
            Alphabet minimizedProceduralInputAlphabet = minimizedAlphabet.getProceduralAlphabet();
            procedures.keySet().retainAll(accessibleProcedures);
            for (Map.Entry e : new HashMap(procedures).entrySet()) {
                Object proc = e.getKey();
                CompactDFA oldDFA = (CompactDFA)e.getValue();
                CompactDFA newDFA = new CompactDFA(minimizedProceduralInputAlphabet);
                Automata.minimize(oldDFA, minimizedProceduralInputAlphabet, newDFA);
                procedures.put(proc, newDFA);
            }
            for (Map.Entry ai : alphabet.getCallAlphabet()) {
                Map l2ciMap = (Map)procedureMap.get(ai);
                ArrayList locations = new ArrayList();
                boolean sink = false;
                for (Map.Entry e : l2ciMap.entrySet()) {
                    if (accessibleProcedures.contains(e.getValue())) {
                        locations.add(e.getKey());
                        continue;
                    }
                    if (sink) continue;
                    locations.add(e.getKey());
                    sink = true;
                }
                Node<AI, CI> dt = SPAConverter.buildDT(sevpa, locations, l2ciMap, cs, as);
                dts.put(ai, dt);
            }
            spa = new StackSPA(minimizedAlphabet, mainProcedure, procedures);
        } else {
            for (Object ai : alphabet.getCallAlphabet()) {
                Node<AI, CI> dt = SPAConverter.buildDT(sevpa, sevpa.getLocations(), (Map)procedureMap.get(ai), cs, as);
                dts.put(ai, dt);
            }
        }
        return new ConversionResult(spa, dts, reverseMapping, new Mapper<AI, CI>(alphabet, mainProcedure, dts, symbolMapper, sevpa::computeOutput));
    }

    private static <L, AI, CI> CompactDFA<CI> buildTemplate(OneSEVPA<L, AI> sevpa, VPAlphabet<AI> alphabet, ProceduralInputAlphabet<CI> spaAlphabet, SymbolMapper<AI, CI> symbolMapper, Map<AI, Map<L, CI>> procedureMap, Map<L, Integer> map) {
        Integer s2;
        Alphabet<CI> proceduralAlphabet = spaAlphabet.getProceduralAlphabet();
        CompactDFA<CI> dfa = new CompactDFA<CI>(proceduralAlphabet, sevpa.size());
        AI r = alphabet.getReturnSymbol(0);
        Object initLoc = sevpa.getInitialLocation();
        for (Object l : sevpa.getLocations()) {
            s2 = (Integer)dfa.addState();
            map.put(l, s2);
            dfa.setInitial(s2, Objects.equals(l, initLoc));
        }
        for (Object l : sevpa.getLocations()) {
            s2 = map.get(l);
            for (Object ai : alphabet.getInternalAlphabet()) {
                CI ci = symbolMapper.mapInternalSymbol(ai);
                Object succ = sevpa.getInternalSuccessor(l, ai);
                Integer sSucc = map.get(succ);
                dfa.setTransition(s2, ci, sSucc);
            }
            for (Object ai : alphabet.getCallAlphabet()) {
                for (Object l2 : sevpa.getLocations()) {
                    int sym = sevpa.encodeStackSym(l, ai);
                    Object succ = sevpa.getReturnSuccessor(l2, r, sym);
                    Integer sSucc = map.get(succ);
                    CI cRet = procedureMap.get(ai).get(l2);
                    dfa.setTransition(s2, cRet, sSucc);
                }
            }
        }
        MutableDFAs.complete(dfa, proceduralAlphabet);
        return dfa;
    }

    private static <L, AI, CI> Node<AI, CI> buildDT(OneSEVPA<L, AI> sevpa, Collection<L> nodes, Map<L, CI> l2ciMap, Collection<Pair<Word<AI>, Word<AI>>> cSet, ArrayStorage<Word<AI>> as) {
        if (nodes.size() == 1) {
            return new Node(l2ciMap.get(nodes.iterator().next()));
        }
        for (Pair<Word<AI>, Word<AI>> cs : cSet) {
            ArrayList<L> acc = new ArrayList<L>(nodes.size());
            ArrayList<L> rej = new ArrayList<L>(nodes.size());
            for (L l : nodes) {
                if (sevpa.accepts(Word.fromWords(cs.getFirst(), as.get(sevpa.getLocationId(l)), cs.getSecond()))) {
                    acc.add(l);
                    continue;
                }
                rej.add(l);
            }
            if (acc.isEmpty() || rej.isEmpty()) continue;
            return new Node<AI, CI>(cs.getFirst(), cs.getSecond(), SPAConverter.buildDT(sevpa, acc, l2ciMap, cSet, as), SPAConverter.buildDT(sevpa, rej, l2ciMap, cSet, as));
        }
        throw new IllegalStateException("Characterizing set was unable to split locations. This should not happen.");
    }

    static class Mapper<AI, CI>
    implements Function<Word<AI>, Word<CI>> {
        private final VPAlphabet<AI> alphabet;
        private final CI initialCall;
        private final Map<AI, Node<AI, CI>> dts;
        private final SymbolMapper<AI, CI> mapper;
        private final Predicate<Word<AI>> answerer;

        Mapper(VPAlphabet<AI> alphabet, CI initialCall, Map<AI, Node<AI, CI>> dts, SymbolMapper<AI, CI> mapper, Predicate<Word<AI>> answerer) {
            this.alphabet = alphabet;
            this.initialCall = initialCall;
            this.dts = dts;
            this.mapper = mapper;
            this.answerer = answerer;
        }

        @Override
        public Word<CI> apply(Word<AI> w) {
            assert (this.alphabet.isWellMatched(w));
            WordBuilder<CI> wb = new WordBuilder<CI>(w.length());
            wb.append(this.initialCall);
            for (int i = 0; i < w.length(); ++i) {
                AI sym = w.getSymbol(i);
                if (this.alphabet.isCallSymbol(sym)) {
                    Node<AI, CI> dt = this.dts.get(sym);
                    Word<AI> wm = this.alphabet.longestWellMatchedPrefix(w.subWord(i + 1));
                    Node<AI, CI> leaf = dt.sift(wm, this.answerer);
                    wb.append(leaf.getLabel());
                    continue;
                }
                if (this.alphabet.isInternalSymbol(sym)) {
                    wb.append(this.mapper.mapInternalSymbol(sym));
                    continue;
                }
                if (this.alphabet.isReturnSymbol(sym)) {
                    wb.append(this.mapper.mapReturnSymbol(sym));
                    continue;
                }
                throw new IllegalArgumentException("Unknown symbol: " + sym);
            }
            wb.append(this.mapper.mapReturnSymbol(this.alphabet.getReturnSymbol(0)));
            return wb.toWord();
        }
    }

    public static class Node<AI, CI> {
        private final Word<AI> prefix;
        private final Word<AI> suffix;
        private final CI label;
        private final Node<AI, CI> trueSucc;
        private final Node<AI, CI> falseSucc;

        Node(CI label) {
            this(null, null, label, null, null);
        }

        Node(Word<AI> prefix, Word<AI> suffix, Node<AI, CI> trueSucc, Node<AI, CI> falseSucc) {
            this(prefix, suffix, null, trueSucc, falseSucc);
        }

        private Node(Word<AI> prefix, Word<AI> suffix, CI label, Node<AI, CI> trueSucc, Node<AI, CI> falseSucc) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.label = label;
            this.trueSucc = trueSucc;
            this.falseSucc = falseSucc;
        }

        public CI getLabel() {
            return this.label;
        }

        public Word<AI> getPrefix() {
            return this.prefix;
        }

        public Word<AI> getSuffix() {
            return this.suffix;
        }

        public boolean isLeaf() {
            return this.label != null;
        }

        public Node<AI, CI> sift(Word<AI> w, Predicate<Word<AI>> oracle) {
            if (this.isLeaf()) {
                return this;
            }
            Word q = Word.fromWords(this.prefix, w, this.suffix);
            boolean answer = oracle.test(q);
            return answer ? this.trueSucc.sift(w, oracle) : this.falseSucc.sift(w, oracle);
        }
    }

    public static class ConversionResult<AI, CI> {
        public final SPA<?, CI> spa;
        public final Map<AI, Node<AI, CI>> dts;
        public final Map<CI, AI> reverseMapping;
        public final Function<Word<AI>, Word<CI>> mapper;

        ConversionResult(SPA<?, CI> spa, Map<AI, Node<AI, CI>> dts, Map<CI, AI> reverseMapping, Function<Word<AI>, Word<CI>> mapper) {
            this.spa = spa;
            this.dts = Collections.unmodifiableMap(dts);
            this.reverseMapping = Collections.unmodifiableMap(reverseMapping);
            this.mapper = mapper;
        }
    }
}

