/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.Collection;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.BlockAutomaton;
import net.automatalib.util.minimizer.OriginalStateCollection;
import net.automatalib.util.minimizer.State;

public final class MinimizationResult<S, L> {
    private final Mapping<S, State<S, L>> stateStorage;
    private final Collection<Block<S, L>> blocks;

    MinimizationResult(Mapping<S, State<S, L>> stateStorage, Collection<Block<S, L>> blocks) {
        this.stateStorage = stateStorage;
        this.blocks = blocks;
    }

    public static <S, L> Collection<S> getStatesInBlock(Block<S, L> block) {
        return new OriginalStateCollection<S>(block.getStates());
    }

    public int getNumBlocks() {
        return this.blocks.size();
    }

    public Collection<Block<S, L>> getBlocks() {
        return this.blocks;
    }

    public S getRepresentative(Block<S, L> block) {
        return block.getStates().choose().getOriginalState();
    }

    public Block<S, L> getBlockForState(S origState) {
        State<S, L> state = this.stateStorage.get(origState);
        return state.getBlock();
    }

    public BlockAutomaton<S, L> asBlockAutomaton() {
        return new BlockAutomaton(this);
    }
}

