/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.modal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.automatalib.automaton.AutomatonCreator;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.fixpoint.Worksets;
import net.automatalib.ts.modal.CompactMTS;
import net.automatalib.ts.modal.ModalTransitionSystem;
import net.automatalib.ts.modal.MutableModalTransitionSystem;
import net.automatalib.util.ts.modal.ModalConjunction;
import net.automatalib.util.ts.modal.ModalParallelComposition;
import net.automatalib.util.ts.modal.ModalRefinement;

public final class MTSs {
    private MTSs() {
    }

    public static <S0, S1, I> CompactMTS<I> conjunction(ModalTransitionSystem<S0, I, ?, ?> mts0, ModalTransitionSystem<S1, I, ?, ?> mts1) {
        return MTSs.conjunction(mts0, mts1, CompactMTS::new);
    }

    public static <A extends MutableModalTransitionSystem<S, I, T, ?>, S, S0, S1, I, T> A conjunction(ModalTransitionSystem<S0, I, ?, ?> mts0, ModalTransitionSystem<S1, I, ?, ?> mts1, AutomatonCreator<A, I> creator) {
        return (A)((MutableModalTransitionSystem)MTSs.conjunctionWithMapping(mts0, mts1, creator).getSecond());
    }

    public static <A extends MutableModalTransitionSystem<S, I, T, ?>, S, S0, S1, I, T> Pair<Map<Pair<S0, S1>, S>, A> conjunctionWithMapping(ModalTransitionSystem<S0, I, ?, ?> mts0, ModalTransitionSystem<S1, I, ?, ?> mts1, AutomatonCreator<A, I> creator) {
        return Worksets.map(new ModalConjunction(mts0, mts1, creator));
    }

    public static <S0, S1, I> CompactMTS<I> compose(ModalTransitionSystem<S0, I, ?, ?> mts0, ModalTransitionSystem<S1, I, ?, ?> mts1) {
        return MTSs.compose(mts0, mts1, CompactMTS::new);
    }

    public static <A extends MutableModalTransitionSystem<S, I, ?, ?>, S, S0, S1, I> A compose(ModalTransitionSystem<S0, I, ?, ?> mts0, ModalTransitionSystem<S1, I, ?, ?> mts1, AutomatonCreator<A, I> creator) {
        return (A)((MutableModalTransitionSystem)MTSs.composeWithMapping(mts0, mts1, creator).getSecond());
    }

    public static <A extends MutableModalTransitionSystem<S, I, ?, ?>, S, S0, S1, I> Pair<Map<Pair<S0, S1>, S>, A> composeWithMapping(ModalTransitionSystem<S0, I, ?, ?> mts0, ModalTransitionSystem<S1, I, ?, ?> mts1, AutomatonCreator<A, I> creator) {
        return Worksets.map(new ModalParallelComposition(mts0, mts1, creator));
    }

    public static <AS, BS, I> boolean isRefinementOf(ModalTransitionSystem<AS, I, ?, ?> a, ModalTransitionSystem<BS, I, ?, ?> b, Collection<I> input) {
        Set<Pair<AS, BS>> refinement = ModalRefinement.refinementRelation(a, b, input);
        HashSet statesA = new HashSet(a.getInitialStates());
        HashSet statesB = new HashSet(b.getInitialStates());
        for (Pair<AS, BS> p : refinement) {
            statesA.remove(p.getFirst());
            statesB.remove(p.getSecond());
        }
        return statesA.isEmpty() && statesB.isEmpty();
    }
}

