/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.modal;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiPredicate;
import net.automatalib.common.util.Pair;
import net.automatalib.ts.modal.ModalTransitionSystem;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;

public final class ModalRefinement {
    private ModalRefinement() {
    }

    private static <BS, I, BT, BTP extends ModalEdgeProperty> Set<BT> partnerTransitions(ModalTransitionSystem<BS, I, BT, BTP> b, BS source, I input, Set<ModalEdgeProperty.ModalType> acceptableValues) {
        HashSet coTransitions = Sets.newHashSetWithExpectedSize(b.getInputAlphabet().size());
        for (Object candidateTransition : b.getTransitions(source, input)) {
            ModalEdgeProperty property = (ModalEdgeProperty)b.getTransitionProperty(candidateTransition);
            if (property == null || !acceptableValues.contains((Object)property.getModalType())) continue;
            coTransitions.add(candidateTransition);
        }
        return coTransitions;
    }

    private static <AS, I, AT, BS, BT> boolean eligiblePartner(ModalTransitionSystem<AS, I, AT, ?> a, ModalTransitionSystem<BS, I, BT, ?> b, Collection<I> inputs, BiPredicate<AS, BS> inRefinementRelation, AS source, BS coSource, Set<ModalEdgeProperty.ModalType> acceptableValues) {
        for (I label : inputs) {
            for (Object transition : a.getTransitions(source, label)) {
                if (!acceptableValues.contains((Object)((ModalEdgeProperty)a.getTransitionProperty(transition)).getModalType())) continue;
                Set<BT> partnerTransitions = ModalRefinement.partnerTransitions(b, coSource, label, acceptableValues);
                Object target = a.getSuccessor(transition);
                boolean eligiblePartner = partnerTransitions.stream().map(b::getSuccessor).anyMatch(s2 -> inRefinementRelation.test(target, s2));
                if (eligiblePartner) continue;
                return false;
            }
        }
        return true;
    }

    public static <AS, BS, I> Set<Pair<AS, BS>> refinementRelation(ModalTransitionSystem<AS, I, ?, ?> implementation, ModalTransitionSystem<BS, I, ?, ?> specification, Collection<I> inputs) {
        HashSet refinement = Sets.newHashSetWithExpectedSize(implementation.size() * specification.size());
        for (Object p : implementation.getStates()) {
            for (Object q : specification.getStates()) {
                refinement.add(Pair.of(p, q));
            }
        }
        EnumSet<ModalEdgeProperty.ModalType> may = EnumSet.of(ModalEdgeProperty.ModalType.MAY, ModalEdgeProperty.ModalType.MUST);
        Set<ModalEdgeProperty.ModalType> must = Collections.singleton(ModalEdgeProperty.ModalType.MUST);
        boolean update = true;
        while (update) {
            update = false;
            Iterator iterator = refinement.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                boolean eligiblePartner = ModalRefinement.eligiblePartner(implementation, specification, inputs, (s2, t) -> refinement.contains(Pair.of(s2, t)), pair.getFirst(), pair.getSecond(), may);
                if (eligiblePartner &= ModalRefinement.eligiblePartner(specification, implementation, inputs, (s2, t) -> refinement.contains(Pair.of(t, s2)), pair.getSecond(), pair.getFirst(), must)) continue;
                update = true;
                iterator.remove();
            }
        }
        return refinement;
    }
}

