/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.traversal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.ts.simple.SimpleTS;
import net.automatalib.util.traversal.VisitedState;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BreadthFirstIterator<S, I>
implements Iterator<S> {
    private final Queue<S> bfsQueue = new ArrayDeque<S>();
    private final MutableMapping<S, @Nullable VisitedState> seen;
    private final SimpleTS<S, I> ts;
    private final Collection<? extends I> inputs;

    BreadthFirstIterator(SimpleTS<S, I> ts, Collection<? extends I> inputs) {
        this.ts = ts;
        this.inputs = inputs;
        this.seen = ts.createStaticStateMapping();
        Set<S> initial = ts.getInitialStates();
        this.bfsQueue.addAll(initial);
        for (Object state : initial) {
            this.seen.put(state, VisitedState.VISITED);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.bfsQueue.isEmpty();
    }

    @Override
    public S next() {
        S state = this.bfsQueue.poll();
        if (state == null) {
            throw new NoSuchElementException();
        }
        for (I input : this.inputs) {
            Set<S> succs = this.ts.getSuccessors(state, input);
            for (Object succ : succs) {
                if (this.seen.put(succ, VisitedState.VISITED) == VisitedState.VISITED) continue;
                this.bfsQueue.add(succ);
            }
        }
        return state;
    }
}

