/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.automatalib.visualization.VisualizationHelper;

public class AggregateVisualizationHelper<N, E>
implements VisualizationHelper<N, E> {
    private final List<VisualizationHelper<N, ? super E>> helpers;

    public AggregateVisualizationHelper(VisualizationHelper<N, ? super E> rootVisualizer, List<? extends VisualizationHelper<N, ? super E>> helpers) {
        this.helpers = new ArrayList<VisualizationHelper<N, ? super E>>(helpers.size() + 1);
        this.helpers.add(rootVisualizer);
        this.helpers.addAll(helpers);
    }

    public AggregateVisualizationHelper(List<? extends VisualizationHelper<N, ? super E>> helpers) {
        this.helpers = new ArrayList<VisualizationHelper<N, VisualizationHelper<N, ? super E>>>(helpers);
    }

    @Override
    public void getGlobalNodeProperties(Map<String, String> properties) {
        for (VisualizationHelper<N, E> helper : this.helpers) {
            helper.getGlobalNodeProperties(properties);
        }
    }

    @Override
    public void getGlobalEdgeProperties(Map<String, String> properties) {
        for (VisualizationHelper<N, E> helper : this.helpers) {
            helper.getGlobalEdgeProperties(properties);
        }
    }

    @Override
    public boolean getNodeProperties(N node, Map<String, String> properties) {
        for (VisualizationHelper<N, E> helper : this.helpers) {
            if (helper.getNodeProperties(node, properties)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean getEdgeProperties(N src, E edge, N tgt, Map<String, String> properties) {
        for (VisualizationHelper<N, E> helper : this.helpers) {
            if (helper.getEdgeProperties(src, edge, tgt, properties)) continue;
            return false;
        }
        return true;
    }
}

