/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row;

import org.ejml.UtilEjml;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class NormOps_DDRM {
    public static void normalizeF(DMatrixRMaj A2) {
        double val = NormOps_DDRM.normF(A2);
        if (val == 0.0) {
            return;
        }
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            A2.div(i, val);
        }
    }

    public static double conditionP(DMatrixRMaj A2, double p) {
        if (p == 2.0) {
            return NormOps_DDRM.conditionP2(A2);
        }
        if (A2.numRows == A2.numCols) {
            DMatrixRMaj A_inv = new DMatrixRMaj(A2.numRows, A2.numCols);
            if (!CommonOps_DDRM.invert(A2, A_inv)) {
                throw new IllegalArgumentException("A can't be inverted.");
            }
            return NormOps_DDRM.normP(A2, p) * NormOps_DDRM.normP(A_inv, p);
        }
        DMatrixRMaj pinv = new DMatrixRMaj(A2.numCols, A2.numRows);
        CommonOps_DDRM.pinv(A2, pinv);
        return NormOps_DDRM.normP(A2, p) * NormOps_DDRM.normP(pinv, p);
    }

    public static double conditionP2(DMatrixRMaj A2) {
        SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(A2.numRows, A2.numCols, false, false, true);
        svd.decompose(A2);
        double[] singularValues = svd.getSingularValues();
        int n = SingularOps_DDRM.rank(svd, UtilEjml.TEST_F64);
        if (n == 0) {
            return 0.0;
        }
        double smallest = Double.MAX_VALUE;
        double largest = Double.MIN_VALUE;
        for (double s2 : singularValues) {
            if (s2 < smallest) {
                smallest = s2;
            }
            if (!(s2 > largest)) continue;
            largest = s2;
        }
        return largest / smallest;
    }

    public static double fastNormF(DMatrixD1 a) {
        double total = 0.0;
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            double val = a.get(i);
            total += val * val;
        }
        return Math.sqrt(total);
    }

    public static double normF(DMatrixD1 a) {
        double total = 0.0;
        double scale = CommonOps_DDRM.elementMaxAbs(a);
        if (scale == 0.0) {
            return 0.0;
        }
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            double val = a.get(i) / scale;
            total += val * val;
        }
        return scale * Math.sqrt(total);
    }

    public static double elementP(DMatrix1Row A2, double p) {
        if (p == 1.0) {
            return CommonOps_DDRM.elementSumAbs(A2);
        }
        if (p == 2.0) {
            return NormOps_DDRM.normF(A2);
        }
        double max = CommonOps_DDRM.elementMaxAbs(A2);
        if (max == 0.0) {
            return 0.0;
        }
        double total = 0.0;
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            double a = A2.get(i) / max;
            total += Math.pow(Math.abs(a), p);
        }
        return max * Math.pow(total, 1.0 / p);
    }

    public static double fastElementP(DMatrixD1 A2, double p) {
        if (p == 2.0) {
            return NormOps_DDRM.fastNormF(A2);
        }
        double total = 0.0;
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            double a = A2.get(i);
            total += Math.pow(Math.abs(a), p);
        }
        return Math.pow(total, 1.0 / p);
    }

    public static double normP(DMatrixRMaj A2, double p) {
        if (p == 1.0) {
            return NormOps_DDRM.normP1(A2);
        }
        if (p == 2.0) {
            return NormOps_DDRM.normP2(A2);
        }
        if (Double.isInfinite(p)) {
            return NormOps_DDRM.normPInf(A2);
        }
        if (MatrixFeatures_DDRM.isVector(A2)) {
            return NormOps_DDRM.elementP(A2, p);
        }
        throw new IllegalArgumentException("Doesn't support induced norms yet.");
    }

    public static double fastNormP(DMatrixRMaj A2, double p) {
        if (p == 1.0) {
            return NormOps_DDRM.normP1(A2);
        }
        if (p == 2.0) {
            return NormOps_DDRM.fastNormP2(A2);
        }
        if (Double.isInfinite(p)) {
            return NormOps_DDRM.normPInf(A2);
        }
        if (MatrixFeatures_DDRM.isVector(A2)) {
            return NormOps_DDRM.fastElementP(A2, p);
        }
        throw new IllegalArgumentException("Doesn't support induced norms yet.");
    }

    public static double normP1(DMatrixRMaj A2) {
        if (MatrixFeatures_DDRM.isVector(A2)) {
            return CommonOps_DDRM.elementSumAbs(A2);
        }
        return NormOps_DDRM.inducedP1(A2);
    }

    public static double normP2(DMatrixRMaj A2) {
        if (MatrixFeatures_DDRM.isVector(A2)) {
            return NormOps_DDRM.normF(A2);
        }
        return NormOps_DDRM.inducedP2(A2);
    }

    public static double fastNormP2(DMatrixRMaj A2) {
        if (MatrixFeatures_DDRM.isVector(A2)) {
            return NormOps_DDRM.fastNormF(A2);
        }
        return NormOps_DDRM.inducedP2(A2);
    }

    public static double normPInf(DMatrixRMaj A2) {
        if (MatrixFeatures_DDRM.isVector(A2)) {
            return CommonOps_DDRM.elementMaxAbs(A2);
        }
        return NormOps_DDRM.inducedPInf(A2);
    }

    public static double inducedP1(DMatrixRMaj A2) {
        double max = 0.0;
        int m3 = A2.numRows;
        int n = A2.numCols;
        for (int j = 0; j < n; ++j) {
            double total = 0.0;
            for (int i = 0; i < m3; ++i) {
                total += Math.abs(A2.get(i, j));
            }
            if (!(total > max)) continue;
            max = total;
        }
        return max;
    }

    public static double inducedP2(DMatrixRMaj A2) {
        SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(A2.numRows, A2.numCols, false, false, true);
        if (!svd.decompose(A2)) {
            throw new RuntimeException("Decomposition failed");
        }
        double[] singularValues = svd.getSingularValues();
        return UtilEjml.max(singularValues, 0, singularValues.length);
    }

    public static double inducedPInf(DMatrixRMaj A2) {
        double max = 0.0;
        int m3 = A2.numRows;
        int n = A2.numCols;
        for (int i = 0; i < m3; ++i) {
            double total = 0.0;
            for (int j = 0; j < n; ++j) {
                total += Math.abs(A2.get(i, j));
            }
            if (!(total > max)) continue;
            max = total;
        }
        return max;
    }
}

