/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.filters.FilterUtils;
import edu.uci.ics.jung.algorithms.shortestpath.PrimMinimumSpanningTree;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.util.TreeUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class MinimumSpanningForest2<V, E> {
    protected Graph<V, E> graph;
    protected Forest<V, E> forest;
    protected Function<? super E, Double> weights = Functions.constant(1.0);

    public MinimumSpanningForest2(Graph<V, E> graph, Supplier<Forest<V, E>> supplier, Supplier<? extends Graph<V, E>> treeFactory, Function<? super E, Double> weights) {
        this(graph, supplier.get(), treeFactory, weights);
    }

    public MinimumSpanningForest2(Graph<V, E> graph, Forest<V, E> forest, Supplier<? extends Graph<V, E>> treeFactory, Function<? super E, Double> weights) {
        if (forest.getVertexCount() != 0) {
            throw new IllegalArgumentException("Supplied Forest must be empty");
        }
        this.graph = graph;
        this.forest = forest;
        if (weights != null) {
            this.weights = weights;
        }
        WeakComponentClusterer<V, E> wcc = new WeakComponentClusterer<V, E>();
        Set component_vertices = wcc.apply(graph);
        Collection<Graph<V, E>> components = FilterUtils.createAllInducedSubgraphs(component_vertices, graph);
        Iterator<Graph<V, E>> iterator = components.iterator();
        while (iterator.hasNext()) {
            PrimMinimumSpanningTree<V, E> mst = new PrimMinimumSpanningTree<V, E>(treeFactory, this.weights);
            Graph<V, E> component = iterator.next();
            Graph subTree = mst.apply(component);
            if (!(subTree instanceof Tree)) continue;
            TreeUtils.addSubTree(forest, (Tree)subTree, null, null);
        }
    }

    public Forest<V, E> getForest() {
        return this.forest;
    }
}

