/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UndirectedSparseGraph<V, E>
extends AbstractTypedGraph<V, E>
implements UndirectedGraph<V, E> {
    protected Map<V, Map<V, E>> vertices = new HashMap<V, Map<V, E>>();
    protected Map<E, Pair<V>> edges = new HashMap<E, Pair<V>>();

    public static <V, E> Supplier<UndirectedGraph<V, E>> getFactory() {
        return new Supplier<UndirectedGraph<V, E>>(){

            @Override
            public UndirectedGraph<V, E> get() {
                return new UndirectedSparseGraph();
            }
        };
    }

    public UndirectedSparseGraph() {
        super(EdgeType.UNDIRECTED);
    }

    @Override
    public boolean addEdge(E edge, Pair<? extends V> endpoints, EdgeType edgeType) {
        V v2;
        this.validateEdgeType(edgeType);
        Pair<V> new_endpoints = this.getValidatedEndpoints(edge, endpoints);
        if (new_endpoints == null) {
            return false;
        }
        V v1 = new_endpoints.getFirst();
        if (this.findEdge(v1, v2 = new_endpoints.getSecond()) != null) {
            return false;
        }
        this.edges.put(edge, new_endpoints);
        if (!this.vertices.containsKey(v1)) {
            this.addVertex(v1);
        }
        if (!this.vertices.containsKey(v2)) {
            this.addVertex(v2);
        }
        this.vertices.get(v1).put(v2, edge);
        this.vertices.get(v2).put(v1, edge);
        return true;
    }

    @Override
    public Collection<E> getInEdges(V vertex) {
        return this.getIncidentEdges(vertex);
    }

    @Override
    public Collection<E> getOutEdges(V vertex) {
        return this.getIncidentEdges(vertex);
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        return this.getNeighbors(vertex);
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        return this.getNeighbors(vertex);
    }

    @Override
    public E findEdge(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        return this.vertices.get(v1).get(v2);
    }

    @Override
    public Collection<E> findEdgeSet(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        ArrayList<E> edge_collection = new ArrayList<E>(1);
        E e = this.findEdge(v1, v2);
        if (e == null) {
            return edge_collection;
        }
        edge_collection.add(e);
        return edge_collection;
    }

    @Override
    public Pair<V> getEndpoints(E edge) {
        return this.edges.get(edge);
    }

    @Override
    public V getSource(E directed_edge) {
        return null;
    }

    @Override
    public V getDest(E directed_edge) {
        return null;
    }

    @Override
    public boolean isSource(V vertex, E edge) {
        return false;
    }

    @Override
    public boolean isDest(V vertex, E edge) {
        return false;
    }

    @Override
    public Collection<E> getEdges() {
        return Collections.unmodifiableCollection(this.edges.keySet());
    }

    @Override
    public Collection<V> getVertices() {
        return Collections.unmodifiableCollection(this.vertices.keySet());
    }

    @Override
    public boolean containsVertex(V vertex) {
        return this.vertices.containsKey(vertex);
    }

    @Override
    public boolean containsEdge(E edge) {
        return this.edges.containsKey(edge);
    }

    @Override
    public int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public int getVertexCount() {
        return this.vertices.size();
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.vertices.get(vertex).keySet());
    }

    @Override
    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.vertices.get(vertex).values());
    }

    @Override
    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put(vertex, new HashMap());
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        for (E edge : new ArrayList<E>(this.vertices.get(vertex).values())) {
            this.removeEdge(edge);
        }
        this.vertices.remove(vertex);
        return true;
    }

    @Override
    public boolean removeEdge(E edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        Pair<V> endpoints = this.getEndpoints(edge);
        V v1 = endpoints.getFirst();
        V v2 = endpoints.getSecond();
        this.vertices.get(v1).remove(v2);
        this.vertices.get(v2).remove(v1);
        this.edges.remove(edge);
        return true;
    }
}

