/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.util;

import edu.uci.ics.jung.visualization.FourPassImageShaper;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageShapeUtils {
    public static Shape getShape(String fileName) {
        return ImageShapeUtils.getShape(fileName, Integer.MAX_VALUE);
    }

    public static Shape getShape(String fileName, int max) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(ImageShapeUtils.class.getResource(fileName));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return ImageShapeUtils.getShape(image, max);
    }

    public static Shape getShape(Image image) {
        return ImageShapeUtils.getShape(image, Integer.MAX_VALUE);
    }

    public static Shape getShape(Image image, int max) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return ImageShapeUtils.getShape(bi, max);
    }

    public static Shape getShape(BufferedImage image, int max) {
        float width = image.getWidth();
        float height = image.getHeight();
        if (width > (float)max || height > (float)max) {
            BufferedImage smaller = new BufferedImage(max, max, 2);
            Graphics2D g2 = smaller.createGraphics();
            AffineTransform at = AffineTransform.getScaleInstance((float)max / width, (float)max / height);
            AffineTransform back = AffineTransform.getScaleInstance(width / (float)max, height / (float)max);
            Graphics2D g22 = g2;
            g22.drawImage(image, at, null);
            g22.dispose();
            return back.createTransformedShape(ImageShapeUtils.getShape(smaller));
        }
        return FourPassImageShaper.getShape(image);
    }
}

