/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.util;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class VertexShapeFactory<V> {
    protected Function<? super V, Integer> vsf;
    protected Function<? super V, Float> varf;
    private static final Rectangle2D theRectangle = new Rectangle2D.Float();
    private static final Ellipse2D theEllipse = new Ellipse2D.Float();
    private static final RoundRectangle2D theRoundRectangle = new RoundRectangle2D.Float();
    private static final GeneralPath thePolygon = new GeneralPath();

    public VertexShapeFactory(Function<? super V, Integer> vsf, Function<? super V, Float> varf) {
        this.vsf = vsf;
        this.varf = varf;
    }

    public VertexShapeFactory() {
        this(Functions.constant(10), Functions.constant(Float.valueOf(1.0f)));
    }

    public Rectangle2D getRectangle(V v) {
        float width = this.vsf.apply(v).intValue();
        float height = width * this.varf.apply(v).floatValue();
        float h_offset = -(width / 2.0f);
        float v_offset = -(height / 2.0f);
        theRectangle.setFrame(h_offset, v_offset, width, height);
        return theRectangle;
    }

    public Ellipse2D getEllipse(V v) {
        theEllipse.setFrame(this.getRectangle(v));
        return theEllipse;
    }

    public RoundRectangle2D getRoundRectangle(V v) {
        Rectangle2D frame = this.getRectangle(v);
        float arc_size = (float)Math.min(frame.getHeight(), frame.getWidth()) / 2.0f;
        theRoundRectangle.setRoundRect(frame.getX(), frame.getY(), frame.getWidth(), frame.getHeight(), arc_size, arc_size);
        return theRoundRectangle;
    }

    public Shape getRegularPolygon(V v, int num_sides) {
        if (num_sides < 3) {
            throw new IllegalArgumentException("Number of sides must be >= 3");
        }
        Rectangle2D frame = this.getRectangle(v);
        float width = (float)frame.getWidth();
        float height = (float)frame.getHeight();
        double angle = 0.0;
        thePolygon.reset();
        thePolygon.moveTo(0.0f, 0.0f);
        thePolygon.lineTo(width, 0.0f);
        double theta = Math.PI * 2 / (double)num_sides;
        for (int i = 2; i < num_sides; ++i) {
            float delta_x = (float)((double)width * Math.cos(angle -= theta));
            float delta_y = (float)((double)width * Math.sin(angle));
            Point2D prev = thePolygon.getCurrentPoint();
            thePolygon.lineTo((float)prev.getX() + delta_x, (float)prev.getY() + delta_y);
        }
        thePolygon.closePath();
        Rectangle2D r = thePolygon.getBounds2D();
        double scale_x = (double)width / r.getWidth();
        double scale_y = (double)height / r.getHeight();
        float translationX = (float)(r.getMinX() + r.getWidth() / 2.0);
        float translationY = (float)(r.getMinY() + r.getHeight() / 2.0);
        AffineTransform at = AffineTransform.getScaleInstance(scale_x, scale_y);
        at.translate(-translationX, -translationY);
        Shape shape = at.createTransformedShape(thePolygon);
        return shape;
    }

    public Shape getRegularStar(V v, int num_points) {
        if (num_points < 5) {
            throw new IllegalArgumentException("Number of sides must be >= 5");
        }
        Rectangle2D frame = this.getRectangle(v);
        float width = (float)frame.getWidth();
        float height = (float)frame.getHeight();
        double theta = Math.PI * 2 / (double)num_points;
        double angle = -theta / 2.0;
        thePolygon.reset();
        thePolygon.moveTo(0.0f, 0.0f);
        float delta_x = width * (float)Math.cos(angle);
        float delta_y = width * (float)Math.sin(angle);
        Point2D prev = thePolygon.getCurrentPoint();
        thePolygon.lineTo((float)prev.getX() + delta_x, (float)prev.getY() + delta_y);
        for (int i = 1; i < num_points; ++i) {
            delta_x = width * (float)Math.cos(angle += theta);
            delta_y = width * (float)Math.sin(angle);
            prev = thePolygon.getCurrentPoint();
            thePolygon.lineTo((float)prev.getX() + delta_x, (float)prev.getY() + delta_y);
            delta_x = width * (float)Math.cos(angle -= theta * 2.0);
            delta_y = width * (float)Math.sin(angle);
            prev = thePolygon.getCurrentPoint();
            thePolygon.lineTo((float)prev.getX() + delta_x, (float)prev.getY() + delta_y);
        }
        thePolygon.closePath();
        Rectangle2D r = thePolygon.getBounds2D();
        double scale_x = (double)width / r.getWidth();
        double scale_y = (double)height / r.getHeight();
        float translationX = (float)(r.getMinX() + r.getWidth() / 2.0);
        float translationY = (float)(r.getMinY() + r.getHeight() / 2.0);
        AffineTransform at = AffineTransform.getScaleInstance(scale_x, scale_y);
        at.translate(-translationX, -translationY);
        Shape shape = at.createTransformedShape(thePolygon);
        return shape;
    }
}

