/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.backend;

import info.scce.addlib.backend.ADDBackend;
import info.scce.addlib.backend.BDDBackend;
import info.scce.addlib.backend.Backend;
import info.scce.addlib.backend.BackendType;
import info.scce.addlib.backend.ZDDBackend;
import info.scce.addlib.nativelib.NativeLibrary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public final class BackendProvider {
    private static final Set<BackendType> BACKENDS = new HashSet<BackendType>();
    private static final Map<BackendType, ADDBackend> ADDBACKENDS = new HashMap<BackendType, ADDBackend>();
    private static final Map<BackendType, BDDBackend> BDDBACKENDS = new HashMap<BackendType, BDDBackend>();
    private static final Map<BackendType, ZDDBackend> ZDDBACKENDS = new HashMap<BackendType, ZDDBackend>();

    private BackendProvider() {
    }

    private static <B extends Backend> B getBackend(Map<BackendType, B> backends, BackendType id) {
        Backend backend = (Backend)backends.get((Object)id);
        if (backend == null) {
            if (BACKENDS.contains((Object)id)) {
                throw new IllegalArgumentException("Backend '" + (Object)((Object)id) + "' is not available.");
            }
            throw new IllegalArgumentException("Unknown backend '" + (Object)((Object)id) + '\'');
        }
        if (!backend.isAvailable()) {
            throw new IllegalStateException("Backend '" + (Object)((Object)id) + "' is not available on this platform");
        }
        return (B)backend;
    }

    private static <B extends Backend> B getBackend(Map<BackendType, B> backends) {
        return (B)backends.values().stream().filter(NativeLibrary::isAvailable).findFirst().orElseThrow(() -> new IllegalStateException("No backend available on this platform"));
    }

    public static ADDBackend getADDBackend(BackendType id) {
        return BackendProvider.getBackend(ADDBACKENDS, id);
    }

    public static ADDBackend getADDBackend() {
        return BackendProvider.getBackend(ADDBACKENDS);
    }

    public static BDDBackend getBDDBackend(BackendType id) {
        return BackendProvider.getBackend(BDDBACKENDS, id);
    }

    public static BDDBackend getBDDBackend() {
        return BackendProvider.getBackend(BDDBACKENDS);
    }

    public static ZDDBackend getZDDBackend(BackendType id) {
        return BackendProvider.getBackend(ZDDBACKENDS, id);
    }

    public static ZDDBackend getZDDBackend() {
        return BackendProvider.getBackend(ZDDBACKENDS);
    }

    static {
        ServiceLoader<ADDBackend> addLoader = ServiceLoader.load(ADDBackend.class);
        ServiceLoader<BDDBackend> bddLoader = ServiceLoader.load(BDDBackend.class);
        ServiceLoader<ZDDBackend> zddLoader = ServiceLoader.load(ZDDBackend.class);
        for (ADDBackend addBackend : addLoader) {
            BACKENDS.add(addBackend.getId());
            ADDBACKENDS.put(addBackend.getId(), addBackend);
        }
        for (BDDBackend bddBackend : bddLoader) {
            BACKENDS.add(bddBackend.getId());
            BDDBACKENDS.put(bddBackend.getId(), bddBackend);
        }
        for (ZDDBackend zddBackend : zddLoader) {
            BACKENDS.add(zddBackend.getId());
            ZDDBACKENDS.put(zddBackend.getId(), zddBackend);
        }
    }
}

