/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.add;

import info.scce.addlib.backend.ADDBackend;
import info.scce.addlib.backend.BackendProvider;
import info.scce.addlib.dd.DDManager;
import info.scce.addlib.dd.add.ADD;
import info.scce.addlib.parser.ADDLanguageLexer;
import info.scce.addlib.parser.ADDLanguageParser;
import info.scce.addlib.parser.ADDVisitor;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;

public class ADDManager
extends DDManager<ADD, ADDBackend> {
    public ADDManager() {
        this(BackendProvider.getADDBackend());
    }

    public ADDManager(ADDBackend backend) {
        super(backend);
    }

    public double readEpsilon() {
        return ((ADDBackend)this.getBackend()).readEpsilon(this.ptr);
    }

    public void setEpsilon(double epsilon) {
        ((ADDBackend)this.getBackend()).setEpsilon(this.ptr, epsilon);
    }

    public double readBackground() {
        long backgroundPtr = ((ADDBackend)this.getBackend()).readBackground(this.ptr);
        return ((ADDBackend)this.getBackend()).v(backgroundPtr);
    }

    public void setBackground(ADD background) {
        if (background.isConstant()) {
            ((ADDBackend)this.getBackend()).setBackground(this.ptr, background.ptr());
        }
    }

    public ADD readOne() {
        long ddNodePtr = ((ADDBackend)this.getBackend()).readOne(this.ptr);
        return (ADD)new ADD(ddNodePtr, this).withRef();
    }

    public ADD readZero() {
        long ddNodePtr = ((ADDBackend)this.getBackend()).readZero(this.ptr);
        return (ADD)new ADD(ddNodePtr, this).withRef();
    }

    public ADD readPlusInfinity() {
        long ddNodePtr = ((ADDBackend)this.getBackend()).readPlusInfinity(this.ptr);
        return (ADD)new ADD(ddNodePtr, this).withRef();
    }

    public ADD readMinusInfinity() {
        long ddNodePtr = ((ADDBackend)this.getBackend()).readMinusInfinity(this.ptr);
        return (ADD)new ADD(ddNodePtr, this).withRef();
    }

    public ADD constant(double value) {
        long ddNodePtr = ((ADDBackend)this.getBackend()).constant(this.ptr, value);
        return (ADD)new ADD(ddNodePtr, this).withRef();
    }

    @Override
    public ADD namedVar(String name) {
        int i = this.varIdx(name);
        return this.backendIthVar(i);
    }

    public ADD namedVar(String name, ADD t, ADD e) {
        return this.ithVar(this.varIdx(name), t, e);
    }

    public ADD namedIthVar(String name, int i) {
        this.addVarName(name, i);
        return this.ithVar(i);
    }

    public ADD namedIthVar(String name, int i, ADD t, ADD e) {
        this.addVarName(name, i);
        return this.ithVar(i, t, e);
    }

    @Override
    public ADD ithVar(int i) {
        this.varName(i);
        return this.backendIthVar(i);
    }

    public ADD ithVar(int i, ADD t, ADD e) {
        ADD ithVar = this.ithVar(i);
        ADD result = ithVar.ite(t, e);
        ithVar.recursiveDeref();
        return result;
    }

    private ADD backendIthVar(int i) {
        long ddNodePtr = ((ADDBackend)this.getBackend()).ithVar(this.ptr, i);
        return (ADD)new ADD(ddNodePtr, this).withRef();
    }

    public ADD newVar() {
        long ddNodePtr = ((ADDBackend)this.getBackend()).newVar(this.ptr);
        ADD result = (ADD)new ADD(ddNodePtr, this).withRef();
        this.createVariableName(result);
        return result;
    }

    public ADD newVarAtLevel(int level) {
        long ddNodePtr = ((ADDBackend)this.getBackend()).newVarAtLevel(this.ptr, level);
        ADD result = (ADD)new ADD(ddNodePtr, this).withRef();
        this.createVariableName(result);
        return result;
    }

    @Override
    public ADD parse(String str) {
        ANTLRInputStream inputStream = new ANTLRInputStream(str);
        ADDLanguageLexer lexer = new ADDLanguageLexer(inputStream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ADDLanguageParser parser = new ADDLanguageParser(tokens);
        ADDVisitor ast = new ADDVisitor(this);
        return (ADD)ast.visit(parser.expr());
    }
}

