/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.bdd;

import info.scce.addlib.backend.BDDBackend;
import info.scce.addlib.dd.DD;
import info.scce.addlib.dd.bdd.BDDManager;
import info.scce.addlib.dd.xdd.XDD;
import info.scce.addlib.dd.xdd.latticedd.example.BooleanLogicDDManager;
import info.scce.addlib.util.Conversions;
import info.scce.addlib.utils.DDConversions;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BDD
extends DD<BDDManager, BDD> {
    public BDD(long ptr, BDDManager ddManager) {
        super(ptr, ddManager);
    }

    public boolean v() {
        this.assertConstant();
        BDD one = ((BDDManager)this.ddManager).readOne();
        boolean isOne = this.equals(one);
        one.recursiveDeref();
        return isOne;
    }

    public boolean isComplement() {
        return Conversions.asBoolean(((BDDBackend)((BDDManager)this.ddManager).getBackend()).isComplement(this.ptr));
    }

    public BDD not() {
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).not(this.ptr);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD ite(BDD t, BDD e) {
        this.assertEqualDDManager(t, e);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).ite(((BDDManager)this.ddManager()).ptr(), this.ptr, t.ptr, e.ptr);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD iteLimit(BDD t, BDD e, int limit) {
        this.assertEqualDDManager(t, e);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).iteLimit(((BDDManager)this.ddManager()).ptr(), this.ptr, t.ptr, e.ptr, limit);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public @Nullable BDD iteConstant(BDD t, BDD e) {
        this.assertEqualDDManager(t, e);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).iteConstant(((BDDManager)this.ddManager).ptr(), this.ptr, t.ptr, e.ptr);
        if (resultPtr == 1L) {
            return null;
        }
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD intersect(BDD g2) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).intersect(((BDDManager)this.ddManager).ptr(), this.ptr, g2.ptr);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD and(BDD g2) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).and(((BDDManager)this.ddManager).ptr(), this.ptr, g2.ptr);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD andLimit(BDD g2, int limit) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).andLimit(((BDDManager)this.ddManager).ptr(), this.ptr, g2.ptr, limit);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD or(BDD g2) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).or(((BDDManager)this.ddManager).ptr(), this.ptr, g2.ptr);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD orLimit(BDD g2, int limit) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).orLimit(((BDDManager)this.ddManager).ptr(), this.ptr, g2.ptr, limit);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD nand(BDD g2) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).nand(((BDDManager)this.ddManager()).ptr(), this.ptr, g2.ptr);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD nor(BDD g2) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager()).getBackend()).nor(((BDDManager)this.ddManager()).ptr(), this.ptr, g2.ptr);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD xor(BDD g2) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager()).getBackend()).xor(((BDDManager)this.ddManager()).ptr(), this.ptr, g2.ptr);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD xnor(BDD g2) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager()).getBackend()).xnor(((BDDManager)this.ddManager()).ptr(), this.ptr, g2.ptr);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD xnorLimit(BDD g2, int limit) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager()).getBackend()).xnorLimit(((BDDManager)this.ddManager()).ptr(), this.ptr, g2.ptr, limit);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public boolean leq(BDD g2) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        int result = ((BDDBackend)((BDDManager)this.ddManager()).getBackend()).leq(((BDDManager)this.ddManager()).ptr(), this.ptr, g2.ptr);
        return Conversions.asBoolean(result);
    }

    public BDD compose(BDD g2, int v) {
        this.assertEqualDDManager((DD<?, ?>)g2);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager()).getBackend()).compose(((BDDManager)this.ddManager()).ptr(), this.ptr, g2.ptr, v);
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    public BDD vectorCompose(BDD ... vector) {
        this.assertEqualDDManager(vector);
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager()).getBackend()).vectorCompose(((BDDManager)this.ddManager()).ptr(), this.ptr, DDConversions.ptrs(vector));
        return (BDD)new BDD(resultPtr, (BDDManager)this.ddManager).withRef();
    }

    @Override
    protected BDD thisCasted() {
        return this;
    }

    @Override
    public BDD t() {
        this.assertNonConstant();
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).t(this.ptr);
        return new BDD(resultPtr, (BDDManager)this.ddManager);
    }

    @Override
    public BDD e() {
        this.assertNonConstant();
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).e(this.ptr);
        return new BDD(resultPtr, (BDDManager)this.ddManager);
    }

    @Override
    public BDD eval(boolean ... input) {
        long resultPtr = ((BDDBackend)((BDDManager)this.ddManager).getBackend()).eval(((BDDManager)this.ddManager()).ptr(), this.ptr, Conversions.asInts(input));
        return new BDD(resultPtr, (BDDManager)this.ddManager);
    }

    public XDD<Boolean> toXDD(BooleanLogicDDManager ddManagerTarget) {
        HashMap<Long, XDD<Boolean>> cache = new HashMap<Long, XDD<Boolean>>();
        XDD<Boolean> result = this.toXDDRecursive(ddManagerTarget, cache);
        cache.remove(this.ptr);
        for (XDD<Boolean> g2 : cache.values()) {
            g2.recursiveDeref();
        }
        return result;
    }

    private XDD<Boolean> toXDDRecursive(BooleanLogicDDManager ddManagerTarget, Map<Long, XDD<Boolean>> cache) {
        XDD<Object> result = cache.get(this.ptr);
        if (result == null) {
            if (this.isConstant()) {
                BDD bddOne = ((BDDManager)this.ddManager).readOne();
                boolean value = this.equals(bddOne);
                result = ddManagerTarget.constant(value);
                bddOne.recursiveDeref();
            } else {
                XDD<Boolean> e;
                XDD<Boolean> t;
                String name = this.readName();
                int idx = ddManagerTarget.varIdx(name);
                boolean isComplement = Conversions.asBoolean(((BDDBackend)((BDDManager)this.ddManager).getBackend()).isComplement(this.ptr));
                if (isComplement) {
                    BDD tmp = this.t().not();
                    t = tmp.toXDDRecursive(ddManagerTarget, cache);
                    tmp.recursiveDeref();
                    tmp = this.e().not();
                    e = tmp.toXDDRecursive(ddManagerTarget, cache);
                    tmp.recursiveDeref();
                } else {
                    t = this.t().toXDDRecursive(ddManagerTarget, cache);
                    e = this.e().toXDDRecursive(ddManagerTarget, cache);
                }
                result = ddManagerTarget.ithVar(idx, t, e);
            }
            cache.put(this.ptr, result);
        }
        return result;
    }

    @Override
    public String toString() {
        if (this.isConstant()) {
            BDD one = ((BDDManager)this.ddManager).readOne();
            String lbl = this.equals(one) ? "1" : "0";
            one.recursiveDeref();
            return lbl;
        }
        return super.toString();
    }
}

