/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.latticedd.example;

import info.scce.addlib.backend.ADDBackend;
import info.scce.addlib.backend.BackendProvider;
import info.scce.addlib.dd.xdd.latticedd.BooleanLatticeDDManager;

public class BoundedFuzzyLogicDDManager
extends BooleanLatticeDDManager<Double> {
    public BoundedFuzzyLogicDDManager() {
        this(BackendProvider.getADDBackend());
    }

    public BoundedFuzzyLogicDDManager(ADDBackend backend) {
        super(backend);
    }

    @Override
    protected Double meet(Double left, Double right) {
        return this.ensureRange(left + right - 1.0);
    }

    @Override
    protected Double join(Double left, Double right) {
        return this.ensureRange(left + right);
    }

    @Override
    protected Double botElement() {
        return 0.0;
    }

    @Override
    protected Double topElement() {
        return 1.0;
    }

    @Override
    protected Double compl(Double x) {
        return this.ensureRange(1.0 - x);
    }

    @Override
    public Double parseElement(String str) {
        return this.ensureRange(Double.parseDouble(str));
    }

    private double ensureRange(double x) {
        if (x > 1.0) {
            return 1.0;
        }
        return Math.max(x, 0.0);
    }
}

