/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.ringlikedd.example;

import info.scce.addlib.backend.ADDBackend;
import info.scce.addlib.backend.BackendProvider;
import info.scce.addlib.dd.xdd.ringlikedd.FieldDDManager;
import info.scce.addlib.dd.xdd.ringlikedd.example.ComplexNumber;

public class ComplexNumberDDManager
extends FieldDDManager<ComplexNumber> {
    public ComplexNumberDDManager() {
        this(BackendProvider.getADDBackend());
    }

    public ComplexNumberDDManager(ADDBackend backend) {
        super(backend);
    }

    @Override
    protected ComplexNumber multInverse(ComplexNumber x) {
        double xRealPart = x.getRealPart();
        double xImaginaryPart = x.getImaginaryPart();
        double denominator = xRealPart * xRealPart + xImaginaryPart * xImaginaryPart;
        double newRealPart = xRealPart / denominator;
        double newImaginaryPart = -xImaginaryPart / denominator;
        return new ComplexNumber(newRealPart, newImaginaryPart);
    }

    @Override
    protected ComplexNumber addInverse(ComplexNumber x) {
        return new ComplexNumber(-x.getRealPart(), -x.getImaginaryPart());
    }

    @Override
    protected ComplexNumber zeroElement() {
        return new ComplexNumber(0.0, 0.0);
    }

    @Override
    protected ComplexNumber oneElement() {
        return new ComplexNumber(1.0, 0.0);
    }

    @Override
    protected ComplexNumber mult(ComplexNumber left, ComplexNumber right) {
        double leftRealPart = left.getRealPart();
        double leftImaginaryPart = left.getImaginaryPart();
        double rightRealPart = right.getRealPart();
        double rightImaginaryPart = right.getImaginaryPart();
        double newRealPart = leftRealPart * rightRealPart - leftImaginaryPart * rightImaginaryPart;
        double newImaginaryPart = leftImaginaryPart * rightRealPart + leftRealPart * rightImaginaryPart;
        return new ComplexNumber(newRealPart, newImaginaryPart);
    }

    @Override
    protected ComplexNumber add(ComplexNumber left, ComplexNumber right) {
        return new ComplexNumber(left.getRealPart() + right.getRealPart(), right.getImaginaryPart() + left.getImaginaryPart());
    }
}

