/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.ringlikedd.example;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;

public class SquareMatrix {
    private final DMatrixRMaj m;

    public SquareMatrix(double[][] data) {
        this(new DMatrixRMaj(data));
    }

    private SquareMatrix(DMatrixRMaj m3) {
        this.m = m3;
    }

    public static SquareMatrix zero(int n) {
        return new SquareMatrix(new DMatrixRMaj(n, n));
    }

    public static SquareMatrix identity(int n) {
        DMatrixRMaj mat = new DMatrixRMaj(n, n);
        CommonOps_DDRM.setIdentity(mat);
        return new SquareMatrix(mat);
    }

    public static SquareMatrix parseSquareMatrix(String str) {
        String strCommaSeparatedRows = str.substring(2, str.length() - 2);
        String[] strRows = strCommaSeparatedRows.split("], \\[");
        double[][] data = new double[strRows.length][];
        for (int i = 0; i < strRows.length; ++i) {
            String strCommaSeparatedValues = strRows[i];
            String[] strValues = strCommaSeparatedValues.split(",");
            double[] row = new double[strValues.length];
            for (int j = 0; j < strValues.length; ++j) {
                double value;
                row[j] = value = Double.parseDouble(strValues[j]);
            }
            data[i] = row;
        }
        return new SquareMatrix(data);
    }

    public int size() {
        return this.m.getNumCols();
    }

    public double[][] data() {
        double[][] arr = new double[this.m.getNumRows()][this.m.getNumCols()];
        for (int row = 0; row < this.m.getNumRows(); ++row) {
            System.arraycopy(this.m.getData(), row * this.m.getNumCols(), arr[row], 0, this.m.getNumCols());
        }
        return arr;
    }

    public SquareMatrix mult(SquareMatrix other) {
        return new SquareMatrix(CommonOps_DDRM.mult(this.m, other.m, null));
    }

    public SquareMatrix multInverse() {
        DMatrixRMaj mat = new DMatrixRMaj(this.m.getNumRows(), this.m.getNumCols());
        CommonOps_DDRM.pinv(this.m, mat);
        return new SquareMatrix(mat);
    }

    public SquareMatrix add(SquareMatrix other) {
        return new SquareMatrix(CommonOps_DDRM.add(this.m, other.m, null));
    }

    public SquareMatrix addInverse() {
        DMatrixRMaj mat = new DMatrixRMaj(this.m.getNumRows(), this.m.getNumCols());
        CommonOps_DDRM.scale(-1.0, this.m, mat);
        return new SquareMatrix(mat);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SquareMatrix that = (SquareMatrix)o;
        return MatrixFeatures_DDRM.isEquals(this.m, that.m, 0.0);
    }

    public int hashCode() {
        return Arrays.hashCode(this.m.getData());
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.data());
    }
}

