/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class IOUtils {
    private IOUtils() {
    }

    public static PrintWriter getBufferedPrintWriterUTF8(File file) throws IOException {
        BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
        return new PrintWriter(bw);
    }

    public static PrintWriter getBufferedPrintWriterCS(File file, String charset) throws IOException {
        Charset cs = Charset.forName(charset);
        BufferedWriter bw = Files.newBufferedWriter(file.toPath(), cs, new OpenOption[0]);
        return new PrintWriter(bw);
    }

    public static PrintWriter getOutputStreamPrintWriterUTF8(OutputStream out) {
        Writer bw = IOUtils.asBufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        return new PrintWriter(bw);
    }

    public static PrintWriter getOutputStreamPrintWriterCS(OutputStream out, String charset) {
        Charset cs = Charset.forName(charset);
        Writer bw = IOUtils.asBufferedWriter(new OutputStreamWriter(out, cs));
        return new PrintWriter(bw);
    }

    public static Writer asBufferedWriter(Writer out) {
        if (IOUtils.isBufferedWriter(out)) {
            return out;
        }
        return new BufferedWriter(out);
    }

    private static boolean isBufferedWriter(Writer writer) {
        return writer instanceof BufferedWriter;
    }
}

