/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.alphabet;

import java.util.Objects;
import net.automatalib.alphabet.AbstractAlphabet;
import net.automatalib.alphabet.Alphabet;

public class SingletonAlphabet<I>
extends AbstractAlphabet<I>
implements Alphabet<I> {
    private final I symbol;

    public SingletonAlphabet(I symbol) {
        this.symbol = symbol;
    }

    @Override
    public I getSymbol(int index) {
        if (index == 0) {
            return this.symbol;
        }
        throw new IllegalArgumentException("Index: " + index + ", size = 1");
    }

    @Override
    public int getSymbolIndex(I symbol) {
        if (Objects.equals(this.symbol, symbol)) {
            return 0;
        }
        throw new IllegalArgumentException("Symbol " + symbol + " is not contained in the alaphabet");
    }

    @Override
    public boolean containsSymbol(I symbol) {
        return Objects.equals(this.symbol, symbol);
    }

    @Override
    public int size() {
        return 1;
    }
}

