/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton;

import java.util.Collection;
import java.util.Objects;
import java.util.function.IntFunction;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.MutableAutomaton;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.abstraction.MutableDeterministicAbstraction;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface MutableDeterministic<S, I, T, SP, TP>
extends UniversalDeterministicAutomaton<S, I, T, SP, TP>,
MutableAutomaton<S, I, T, SP, TP> {
    @Override
    default public void setInitial(S state, boolean initial) {
        Object currInitial = this.getInitialState();
        boolean equal = Objects.equals(state, currInitial);
        if (initial) {
            if (currInitial == null) {
                this.setInitialState(state);
            } else if (!equal) {
                throw new IllegalStateException("Cannot set state '" + state + "' as additional initial state (current initial state: '" + currInitial + "'.");
            }
        } else if (equal) {
            this.setInitialState(null);
        }
    }

    @Override
    default public void setTransitions(S state, I input, Collection<? extends T> transitions) {
        int num = transitions.size();
        if (num > 1) {
            throw new IllegalArgumentException("Deterministic automaton can not have multiple transitions for the same input symbol.");
        }
        T trans = num > 0 ? (T)transitions.iterator().next() : null;
        this.setTransition(state, input, trans);
    }

    @Override
    default public void removeTransition(S state, I input, T transition) {
        if (transition == null) {
            return;
        }
        Object currTrans = this.getTransition(state, input);
        if (transition.equals(currTrans)) {
            this.setTransition(state, input, null);
        }
    }

    @Override
    default public void removeAllTransitions(S state, I input) {
        this.setTransition(state, input, null);
    }

    @Override
    default public void addTransition(S state, I input, T transition) {
        Object currTrans = this.getTransition(state, input);
        if (currTrans != null) {
            throw new IllegalStateException("Cannot add transition " + transition + " to deterministic automaton: transition already defined for state " + state + " and input " + input + ".");
        }
        this.setTransition(state, input, transition);
    }

    public void setInitialState(@Nullable S var1);

    public void setTransition(S var1, I var2, @Nullable T var3);

    default public void setTransition(S state, I input, @Nullable S successor, TP property) {
        if (successor != null) {
            Object trans = this.createTransition(successor, property);
            this.setTransition(state, input, trans);
        }
    }

    @Override
    default public FullIntAbstraction<T, SP, TP> fullIntAbstraction(Alphabet<I> alphabet) {
        return this.fullIntAbstraction(alphabet.size(), alphabet);
    }

    @Override
    default public FullIntAbstraction<T, SP, TP> fullIntAbstraction(int numInputs, IntFunction<? extends I> symMapping) {
        return new MutableDeterministicAbstraction.FullIntAbstraction(this.stateIntAbstraction(), numInputs, symMapping);
    }

    @Override
    default public StateIntAbstraction<I, T, SP, TP> stateIntAbstraction() {
        return new MutableDeterministicAbstraction.StateIntAbstraction(this);
    }

    public static interface FullIntAbstraction<T, SP, TP>
    extends IntAbstraction<T, SP, TP>,
    UniversalDeterministicAutomaton.FullIntAbstraction<T, SP, TP> {
        public void setTransition(int var1, int var2, @Nullable T var3);

        public void setTransition(int var1, int var2, int var3, TP var4);
    }

    public static interface StateIntAbstraction<I, T, SP, TP>
    extends IntAbstraction<T, SP, TP>,
    UniversalDeterministicAutomaton.StateIntAbstraction<I, T, SP, TP> {
        public void setTransition(int var1, I var2, @Nullable T var3);

        public void setTransition(int var1, I var2, int var3, TP var4);
    }

    public static interface IntAbstraction<T, SP, TP>
    extends UniversalDeterministicAutomaton.IntAbstraction<T, SP, TP> {
        public void setStateProperty(int var1, SP var2);

        public void setTransitionProperty(T var1, TP var2);

        public void setInitialState(int var1);

        public T createTransition(int var1, TP var2);

        default public int addIntState() {
            return this.addIntState(null);
        }

        public int addIntState(@Nullable SP var1);

        default public int addIntInitialState() {
            return this.addIntInitialState(null);
        }

        public int addIntInitialState(@Nullable SP var1);
    }
}

