/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton;

import java.util.Arrays;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.CompactTransition;
import net.automatalib.automaton.base.AbstractCompact;
import net.automatalib.automaton.base.AbstractCompactDeterministic;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UniversalCompactDet<I, SP, TP>
extends AbstractCompactDeterministic<I, CompactTransition<TP>, SP, TP> {
    private int[] transitions;
    private @Nullable Object[] stateProperties;
    private @Nullable Object[] transitionProperties;

    public UniversalCompactDet(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public UniversalCompactDet(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        int numTrans = stateCapacity * this.numInputs();
        this.transitions = new int[numTrans];
        this.stateProperties = new Object[stateCapacity];
        this.transitionProperties = new Object[numTrans];
        Arrays.fill(this.transitions, -1);
    }

    protected UniversalCompactDet(Alphabet<I> alphabet, UniversalCompactDet<?, SP, TP> other) {
        super(alphabet, (AbstractCompactDeterministic<?, ?, ?, ?>)other);
        this.transitions = (int[])other.transitions.clone();
        this.stateProperties = (Object[])other.stateProperties.clone();
        this.transitionProperties = (Object[])other.transitionProperties.clone();
    }

    @Override
    public @Nullable CompactTransition<TP> getTransition(int state, int input) {
        int idx = this.toMemoryIndex(state, input);
        int succ = this.transitions[idx];
        if (succ == -1) {
            return null;
        }
        Object output = this.transitionProperties[idx];
        return new CompactTransition<Object>(idx, succ, output);
    }

    @Override
    public int getIntSuccessor(CompactTransition<TP> transition) {
        return transition.getSuccId();
    }

    @Override
    public void setStateProperty(int state, @Nullable SP property) {
        this.stateProperties[state] = property;
    }

    @Override
    public void setTransitionProperty(CompactTransition<TP> transition, TP property) {
        transition.setProperty(property);
        if (transition.isAutomatonTransition()) {
            this.transitionProperties[transition.getMemoryIdx()] = property;
        }
    }

    @Override
    public CompactTransition<TP> createTransition(int successor, TP property) {
        return new CompactTransition<TP>(successor, property);
    }

    @Override
    public void removeAllTransitions(Integer state) {
        int lower = state * this.numInputs();
        int upper = lower + this.numInputs();
        Arrays.fill(this.transitions, lower, upper, -1);
        Arrays.fill(this.transitionProperties, lower, upper, null);
    }

    @Override
    public void setTransition(int state, int input, @Nullable CompactTransition<TP> transition) {
        if (transition == null) {
            this.setTransition(state, input, -1, (TP)null);
        } else {
            this.setTransition(state, input, transition.getSuccId(), transition.getProperty());
            transition.setMemoryIdx(this.toMemoryIndex(state, input));
        }
    }

    @Override
    public void setTransition(int state, int input, int successor, @Nullable TP property) {
        int idx = this.toMemoryIndex(state, input);
        this.transitions[idx] = successor;
        this.transitionProperties[idx] = property;
    }

    @Override
    public SP getStateProperty(int state) {
        return (SP)this.stateProperties[state];
    }

    @Override
    public TP getTransitionProperty(CompactTransition<TP> transition) {
        return transition.getProperty();
    }

    @Override
    public void clear() {
        int endIdx = this.size() * this.numInputs();
        Arrays.fill(this.stateProperties, 0, this.size(), null);
        Arrays.fill(this.transitions, 0, endIdx, -1);
        Arrays.fill(this.transitionProperties, 0, endIdx, null);
        super.clear();
    }

    @Override
    protected void updateStateStorage(AbstractCompact.Payload payload) {
        this.stateProperties = this.updateStateStorage(this.stateProperties, null, payload);
        super.updateStateStorage(payload);
    }

    @Override
    protected void updateTransitionStorage(AbstractCompact.Payload payload) {
        this.transitions = this.updateTransitionStorage(this.transitions, -1, payload);
        this.transitionProperties = this.updateTransitionStorage(this.transitionProperties, null, payload);
    }
}

