/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.graph;

import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.automaton.Automaton;
import net.automatalib.automaton.graph.AbstractAutomatonGraphView;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.visualization.AutomatonVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;

public class AutomatonGraphView<S, I, T, A extends Automaton<S, I, T>>
extends AbstractAutomatonGraphView<S, A, TransitionEdge<I, T>> {
    protected final Collection<? extends I> inputs;

    public AutomatonGraphView(A automaton, Collection<? extends I> inputs) {
        super(automaton);
        this.inputs = inputs;
    }

    @Override
    public Collection<TransitionEdge<I, T>> getOutgoingEdges(S node) {
        return AutomatonGraphView.createTransitionEdges(this.automaton, this.inputs, node);
    }

    public static <S, I, T> Collection<TransitionEdge<I, T>> createTransitionEdges(Automaton<S, I, T> automaton, Collection<? extends I> inputs, S state) {
        ArrayList<TransitionEdge<I, T>> result = new ArrayList<TransitionEdge<I, T>>();
        for (I input : inputs) {
            Collection transitions = automaton.getTransitions(state, input);
            for (Object t : transitions) {
                result.add(new TransitionEdge(input, t));
            }
        }
        return result;
    }

    @Override
    public S getTarget(TransitionEdge<I, T> edge) {
        return this.automaton.getSuccessor(edge.getTransition());
    }

    @Override
    public VisualizationHelper<S, TransitionEdge<I, T>> getVisualizationHelper() {
        return new AutomatonVisualizationHelper(this.automaton);
    }
}

