/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.procedural;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.procedural.SPMM;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EmptySPMM<I, O>
implements SPMM<Void, I, Void, O> {
    private final ProceduralInputAlphabet<I> alphabet;
    private final O errorOutput;

    public EmptySPMM(ProceduralInputAlphabet<I> alphabet, O errorOutput) {
        this.alphabet = alphabet;
        this.errorOutput = errorOutput;
    }

    @Override
    public @Nullable I getInitialProcedure() {
        return null;
    }

    @Override
    public ProceduralInputAlphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public O getErrorOutput() {
        return this.errorOutput;
    }

    @Override
    public Map<I, MealyMachine<?, I, ?, O>> getProcedures() {
        return Collections.emptyMap();
    }

    @Override
    public Word<O> computeSuffixOutput(Iterable<? extends I> prefix, Iterable<? extends I> suffix) {
        int length = Iterables.size(suffix);
        return Word.fromList(Collections.nCopies(length, this.errorOutput));
    }

    @Override
    public Void getTransition(Void state, I input) {
        return null;
    }

    @Override
    public @Nullable Void getInitialState() {
        return null;
    }

    @Override
    public O getTransitionOutput(Void transition) {
        return this.errorOutput;
    }

    @Override
    public Void getSuccessor(Void transition) {
        return null;
    }
}

