/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.procedural;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.SBA;
import net.automatalib.automaton.procedural.StackState;
import net.automatalib.ts.simple.SimpleDTS;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StackSBA<S, I>
implements SBA<StackState<S, I, DFA<S, I>>, I>,
SimpleDTS<StackState<S, I, DFA<S, I>>, I> {
    private final ProceduralInputAlphabet<I> alphabet;
    private final @Nullable I initialCall;
    private final Map<I, DFA<S, I>> procedures;

    public StackSBA(ProceduralInputAlphabet<I> alphabet, @Nullable I initialCall, Map<I, ? extends DFA<? extends S, I>> procedures) {
        this.alphabet = alphabet;
        this.initialCall = initialCall;
        this.procedures = procedures;
    }

    @Override
    public StackState<S, I, DFA<S, I>> getTransition(StackState<S, I, DFA<S, I>> state, I input) {
        if (state.isSink() || state.isTerm()) {
            return StackState.sink();
        }
        if (this.alphabet.isInternalSymbol(input)) {
            if (state.isInit()) {
                return StackState.sink();
            }
            DFA<Object, I> model = state.getProcedure();
            Object next = model.getTransition(state.getCurrentState(), input);
            if (next == null || !model.isAccepting(next)) {
                return StackState.sink();
            }
            return state.updateState(next);
        }
        if (this.alphabet.isCallSymbol(input)) {
            StackState returnState;
            if (state.isInit() && !Objects.equals(this.initialCall, input)) {
                return StackState.sink();
            }
            DFA<S, I> model = this.procedures.get(input);
            if (model == null) {
                return StackState.sink();
            }
            Object next = model.getInitialState();
            if (next == null) {
                return StackState.sink();
            }
            if (state.isInit()) {
                returnState = StackState.term();
            } else {
                DFA<S, I> p = state.getProcedure();
                S succ = p.getSuccessor(state.getCurrentState(), input);
                if (succ == null || !p.isAccepting(succ)) {
                    return StackState.sink();
                }
                returnState = state.updateState(succ);
            }
            return returnState.push(model, next);
        }
        if (this.alphabet.isReturnSymbol(input)) {
            if (state.isInit()) {
                return StackState.sink();
            }
            DFA<S, I> model = state.getProcedure();
            S succ = model.getSuccessor(state.getCurrentState(), input);
            if (succ == null || !model.isAccepting(succ)) {
                return StackState.sink();
            }
            return state.pop();
        }
        return StackState.sink();
    }

    @Override
    public boolean isAccepting(StackState<S, I, DFA<S, I>> state) {
        return !state.isSink() && (state.isInit() || state.isTerm() || state.getProcedure().isAccepting(state.getCurrentState()));
    }

    @Override
    public StackState<S, I, DFA<S, I>> getInitialState() {
        return StackState.init();
    }

    @Override
    public @Nullable I getInitialProcedure() {
        return this.initialCall;
    }

    @Override
    public ProceduralInputAlphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public Map<I, DFA<?, I>> getProcedures() {
        return Collections.unmodifiableMap(this.procedures);
    }
}

