/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.visualization;

import java.util.Map;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.transducer.TransitionOutputAutomaton;
import net.automatalib.automaton.visualization.AutomatonVisualizationHelper;

public class MealyVisualizationHelper<S, I, T, O>
extends AutomatonVisualizationHelper<S, I, T, TransitionOutputAutomaton<S, I, T, O>> {
    public MealyVisualizationHelper(TransitionOutputAutomaton<S, I, T, O> automaton) {
        super(automaton);
    }

    @Override
    public boolean getEdgeProperties(S src, TransitionEdge<I, T> edge, S tgt, Map<String, String> properties) {
        super.getEdgeProperties(src, edge, tgt, properties);
        StringBuilder labelBuilder = new StringBuilder();
        labelBuilder.append(edge.getInput()).append(" / ");
        Object output = ((TransitionOutputAutomaton)this.automaton).getTransitionOutput(edge.getTransition());
        if (output != null) {
            labelBuilder.append(output);
        }
        properties.put("label", labelBuilder.toString());
        return true;
    }
}

