/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.brics;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.automatalib.automaton.fsa.FiniteStateAcceptor;
import net.automatalib.automaton.graph.AbstractAutomatonGraphView;
import net.automatalib.brics.BricsTransitionProperty;
import net.automatalib.brics.BricsVisualizationHelper;
import net.automatalib.graph.UniversalGraph;
import net.automatalib.graph.concept.GraphViewable;
import net.automatalib.visualization.VisualizationHelper;

public abstract class AbstractBricsAutomaton
implements FiniteStateAcceptor<State, Character>,
GraphViewable {
    protected final Automaton automaton;

    public AbstractBricsAutomaton(Automaton automaton, boolean totalize) {
        this.automaton = automaton;
        if (totalize) {
            State s2 = new State();
            s2.addTransition(new Transition('\u0000', '\uffff', s2));
            for (State p : automaton.getStates()) {
                int maxi = 0;
                for (Transition t : p.getSortedTransitions(false)) {
                    if (t.getMin() > maxi) {
                        p.addTransition(new Transition((char)maxi, (char)(t.getMin() - '\u0001'), s2));
                    }
                    if (t.getMin() + '\u0001' <= maxi) continue;
                    maxi = t.getMax() + '\u0001';
                }
                if (maxi > 65535) continue;
                p.addTransition(new Transition((char)maxi, '\uffff', s2));
            }
        }
    }

    public Automaton getBricsAutomaton() {
        return this.automaton;
    }

    @Override
    public boolean isAccepting(State state) {
        return state.isAccept();
    }

    @Override
    public Collection<State> getTransitions(State state, Character input) {
        List transitions = state.getSortedTransitions(false);
        HashSet<State> result = new HashSet<State>();
        for (Transition t : transitions) {
            char min2 = t.getMin();
            if (input.charValue() < min2) break;
            char max = t.getMax();
            if (input.charValue() > max) continue;
            result.add(t.getDest());
        }
        return result;
    }

    @Override
    public Set<State> getInitialStates() {
        return Collections.singleton(this.automaton.getInitialState());
    }

    @Override
    public Collection<State> getStates() {
        return this.automaton.getStates();
    }

    public GraphView graphView() {
        return new GraphView();
    }

    public class GraphView
    extends AbstractAutomatonGraphView<State, AbstractBricsAutomaton, Transition>
    implements UniversalGraph<State, Transition, Boolean, BricsTransitionProperty> {
        public GraphView() {
            super(AbstractBricsAutomaton.this);
        }

        @Override
        public Collection<Transition> getOutgoingEdges(State node) {
            return node.getTransitions();
        }

        @Override
        public State getTarget(Transition edge) {
            return edge.getDest();
        }

        @Override
        public VisualizationHelper<State, Transition> getVisualizationHelper() {
            return new BricsVisualizationHelper(AbstractBricsAutomaton.this);
        }

        @Override
        public Boolean getNodeProperty(State node) {
            return node.isAccept();
        }

        @Override
        public BricsTransitionProperty getEdgeProperty(Transition edge) {
            return new BricsTransitionProperty(edge);
        }
    }
}

