/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.dag;

import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.dag.StateSignature;

final class State {
    static final State SINK = new State(new StateSignature(0, Acceptance.FALSE));
    private final StateSignature signature;
    private int numIncoming;

    State(StateSignature signature) {
        this.signature = signature;
        this.numIncoming = 0;
    }

    void increaseIncoming() {
        ++this.numIncoming;
    }

    void decreaseIncoming() {
        --this.numIncoming;
    }

    boolean isConfluence() {
        return this.numIncoming > 1;
    }

    Acceptance getAcceptance() {
        if (this.signature == null) {
            return Acceptance.FALSE;
        }
        return this.signature.acceptance;
    }

    State getSuccessor(int idx) {
        return ((State[])this.signature.successors.array)[idx];
    }

    StateSignature getSignature() {
        return this.signature;
    }

    public String toString() {
        if (this.isSink()) {
            return "sink";
        }
        return "s";
    }

    boolean isSink() {
        return this == SINK;
    }

    void ensureInputCapacity(int capacity) {
        this.signature.successors.ensureCapacity(capacity);
    }
}

