/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.moore.tree;

import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.transducer.MooreMachine;
import net.automatalib.automaton.visualization.MooreVisualizationHelper;
import net.automatalib.common.util.mapping.MapMapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.graph.Graph;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.moore.IncrementalMooreBuilder;
import net.automatalib.incremental.moore.tree.Node;
import net.automatalib.ts.output.MooreTransitionSystem;
import net.automatalib.util.ts.traversal.TSTraversal;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IncrementalMooreTreeBuilder<I, O>
implements IncrementalMooreBuilder<I, O> {
    private final Alphabet<I> alphabet;
    private int alphabetSize;
    private @Nullable Node<O> root;

    public IncrementalMooreTreeBuilder(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        int newAlphabetSize;
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        if (this.alphabetSize < (newAlphabetSize = this.alphabet.size()) && this.root != null) {
            this.ensureInputCapacity(this.root, this.alphabetSize, newAlphabetSize);
        }
        this.alphabetSize = newAlphabetSize;
    }

    private void ensureInputCapacity(Node<O> node, int oldAlphabetSize, int newAlphabetSize) {
        node.ensureInputCapacity(newAlphabetSize);
        for (int i = 0; i < oldAlphabetSize; ++i) {
            Node<O> child = node.getChild(i);
            if (child == null) continue;
            this.ensureInputCapacity(child, oldAlphabetSize, newAlphabetSize);
        }
    }

    @Override
    public @Nullable Word<I> findSeparatingWord(MooreMachine<?, I, ?, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private <S, T> @Nullable Word<I> doFindSeparatingWord(MooreMachine<S, I, T, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        Object init2 = target.getInitialState();
        if (this.root == null && init2 == null) {
            return null;
        }
        if (this.root == null || init2 == null) {
            return omitUndefined ? null : Word.epsilon();
        }
        if (!Objects.equals(this.root.getOutput(), target.getStateOutput(init2))) {
            return Word.epsilon();
        }
        Record<@Nullable S, ? extends I, O> init = new Record(init2, this.root, null, inputs.iterator());
        ArrayDeque<Record<@Nullable Object, ? extends I, O>> dfsStack = new ArrayDeque<Record<Object, ? extends I, O>>();
        dfsStack.push(init);
        while (!dfsStack.isEmpty()) {
            Object automatonSucc;
            @Nullable @NonNull Record rec = (Record)dfsStack.peek();
            if (!rec.inputIt.hasNext()) {
                dfsStack.pop();
                continue;
            }
            Object input = rec.inputIt.next();
            int inputIdx = this.alphabet.getSymbolIndex(input);
            Node succ = rec.treeNode.getChild(inputIdx);
            if (succ == null) continue;
            @Nullable S state = rec.automatonState;
            Object s2 = automatonSucc = state == null ? null : (Object)target.getSuccessor(state, input);
            if (automatonSucc == null && omitUndefined) continue;
            if (automatonSucc == null || !Objects.equals(target.getStateOutput(automatonSucc), succ.getOutput())) {
                WordBuilder wb = new WordBuilder(dfsStack.size());
                wb.append(input);
                dfsStack.pop();
                while (!dfsStack.isEmpty()) {
                    wb.append(rec.incomingInput);
                    rec = (Record)dfsStack.pop();
                }
                return wb.reverse().toWord();
            }
            dfsStack.push(new Record(automatonSucc, succ, input, inputs.iterator()));
        }
        return null;
    }

    @Override
    public boolean lookup(Word<? extends I> inputWord, List<? super O> output) {
        Node<O> curr = this.root;
        if (curr == null) {
            return false;
        }
        output.add(curr.getOutput());
        for (I sym : inputWord) {
            int symIdx = this.alphabet.getSymbolIndex(sym);
            Node<O> succ = curr.getChild(symIdx);
            if (succ == null) {
                return false;
            }
            output.add(succ.getOutput());
            curr = succ;
        }
        return true;
    }

    @Override
    public void insert(Word<? extends I> word, Word<? extends O> output) {
        assert (word.size() + 1 == output.size());
        Iterator<O> outIter = output.iterator();
        O rootOut = outIter.next();
        if (this.root == null) {
            this.root = new Node<O>(rootOut);
        }
        Node<O> curr = this.root;
        for (I sym : word) {
            int inputIdx = this.alphabet.getSymbolIndex(sym);
            Node<O> succ = curr.getChild(inputIdx);
            if (succ == null) {
                succ = new Node<O>(outIter.next());
                curr.setChild(inputIdx, this.alphabetSize, succ);
            } else if (!Objects.equals(succ.getOutput(), outIter.next())) {
                throw new ConflictException();
            }
            curr = succ;
        }
    }

    @Override
    public MooreTransitionSystem<?, I, ?, O> asTransitionSystem() {
        return new TransitionSystemView();
    }

    @Override
    public Graph<?, ?> asGraph() {
        return new MooreMachine.MooreGraphView<Node<O>, I, Node<O>, O, TransitionSystemView>(new TransitionSystemView(), this.alphabet){

            @Override
            public VisualizationHelper<Node<O>, TransitionEdge<I, Node<O>>> getVisualizationHelper() {
                return new MooreVisualizationHelper<Node<O>, I, Node<O>, O>((MooreMachine)this.automaton){

                    @Override
                    public boolean getNodeProperties(Node<O> node, Map<String, String> properties) {
                        super.getNodeProperties(node, properties);
                        properties.put("label", String.valueOf(node.getOutput()));
                        return true;
                    }
                };
            }
        };
    }

    private class TransitionSystemView
    implements MooreMachine<Node<O>, I, Node<O>, O> {
        private TransitionSystemView() {
        }

        @Override
        public @Nullable Node<O> getInitialState() {
            return IncrementalMooreTreeBuilder.this.root;
        }

        @Override
        public O getStateOutput(Node<O> state) {
            return state.getOutput();
        }

        @Override
        public @Nullable Node<O> getTransition(Node<O> state, I input) {
            return state.getChild(IncrementalMooreTreeBuilder.this.alphabet.getSymbolIndex(input));
        }

        @Override
        public Node<O> getSuccessor(Node<O> transition) {
            return transition;
        }

        @Override
        public Collection<Node<O>> getStates() {
            ArrayList result = new ArrayList();
            Iterators.addAll(result, TSTraversal.breadthFirstIterator(this, IncrementalMooreTreeBuilder.this.alphabet));
            return result;
        }

        @Override
        public <V> MutableMapping<Node<O>, V> createStaticStateMapping() {
            return new MapMapping();
        }
    }

    private static final class Record<S, I, O> {
        public final S automatonState;
        public final Node<O> treeNode;
        public final I incomingInput;
        public final Iterator<? extends I> inputIt;

        Record(S automatonState, Node<O> treeNode, I incomingInput, Iterator<? extends I> inputIt) {
            this.automatonState = automatonState;
            this.treeNode = treeNode;
            this.incomingInput = incomingInput;
            this.inputIt = inputIt;
        }
    }
}

