/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.solver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.transformer.AbstractPropertyTransformer;
import net.automatalib.modelchecker.m3c.transformer.TransformerSerializer;

public final class SolverState<N, T extends AbstractPropertyTransformer<T, L, AP>, L, AP> {
    private final List<String> updatedPropTransformer;
    private final List<List<String>> compositions;
    private final List<FormulaNode<L, AP>> updatedNodeSatisfiedSubformula;
    private final N updatedNode;
    private final L updatedNodePMPG;
    private final Map<L, Set<?>> workSet;

    SolverState(List<String> updatedPropTransformer, List<List<String>> compositions, N updatedNode, L updatedNodePMPG, Map<L, Set<?>> workSet, List<FormulaNode<L, AP>> updatedNodeSatisfiedSubformula) {
        this.updatedPropTransformer = updatedPropTransformer;
        this.compositions = compositions;
        this.updatedNode = updatedNode;
        this.updatedNodePMPG = updatedNodePMPG;
        this.workSet = workSet;
        this.updatedNodeSatisfiedSubformula = updatedNodeSatisfiedSubformula;
    }

    public T getUpdatedPropTransformer(TransformerSerializer<T, L, AP> serializer) {
        return serializer.deserialize(this.updatedPropTransformer);
    }

    public List<T> getCompositions(TransformerSerializer<T, L, AP> serializer) {
        ArrayList<T> result = new ArrayList<T>(this.compositions.size());
        for (List<String> c : this.compositions) {
            result.add(serializer.deserialize(c));
        }
        return result;
    }

    public List<FormulaNode<L, AP>> getUpdatedNodeSatisfiedSubformula() {
        return this.updatedNodeSatisfiedSubformula;
    }

    public N getUpdatedNode() {
        return this.updatedNode;
    }

    public L getUpdatedNodePMPG() {
        return this.updatedNodePMPG;
    }

    public Map<L, Set<?>> getWorkSet() {
        return this.workSet;
    }
}

