/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import net.automatalib.automaton.FiniteAlphabetAutomaton;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.taf.parser.DefaultTAFBuilderDFA;
import net.automatalib.serialization.taf.parser.DefaultTAFBuilderMealy;
import net.automatalib.serialization.taf.parser.InternalTAFParser;
import net.automatalib.serialization.taf.parser.ParseException;
import net.automatalib.serialization.taf.parser.TAFFormatException;
import net.automatalib.serialization.taf.parser.TAFParseDiagnosticListener;
import net.automatalib.serialization.taf.parser.Type;

public final class TAFParser {
    private TAFParser() {
    }

    public static CompactDFA<String> parseDFA(InputStream stream, TAFParseDiagnosticListener listener) throws IOException {
        try (Reader r = IOUtil.asUncompressedBufferedNonClosingUTF8Reader(stream);){
            CompactDFA<String> compactDFA = TAFParser.parseDFA(r, listener);
            return compactDFA;
        }
    }

    public static CompactDFA<String> parseDFA(Reader reader, TAFParseDiagnosticListener listener) {
        InternalTAFParser parser = new InternalTAFParser(reader);
        parser.setDiagnosticListener(listener);
        DefaultTAFBuilderDFA builder = new DefaultTAFBuilderDFA(parser);
        try {
            parser.dfa(builder);
        }
        catch (ParseException ex) {
            throw new TAFFormatException(ex);
        }
        return (CompactDFA)builder.finish();
    }

    public static CompactDFA<String> parseDFA(File file, TAFParseDiagnosticListener listener) throws IOException {
        try (InputStream is = IOUtil.asBufferedInputStream(file);){
            CompactDFA<String> compactDFA = TAFParser.parseDFA(is, listener);
            return compactDFA;
        }
    }

    public static CompactDFA<String> parseDFA(String string, TAFParseDiagnosticListener listener) {
        return TAFParser.parseDFA(new StringReader(string), listener);
    }

    public static CompactMealy<String, String> parseMealy(InputStream stream, TAFParseDiagnosticListener listener) throws IOException {
        try (Reader r = IOUtil.asUncompressedBufferedNonClosingUTF8Reader(stream);){
            CompactMealy<String, String> compactMealy = TAFParser.parseMealy(r, listener);
            return compactMealy;
        }
    }

    public static CompactMealy<String, String> parseMealy(Reader reader, TAFParseDiagnosticListener listener) {
        InternalTAFParser parser = new InternalTAFParser(reader);
        parser.setDiagnosticListener(listener);
        DefaultTAFBuilderMealy builder = new DefaultTAFBuilderMealy(parser);
        try {
            parser.mealy(builder);
        }
        catch (ParseException ex) {
            throw new TAFFormatException(ex);
        }
        return (CompactMealy)builder.finish();
    }

    public static CompactMealy<String, String> parseMealy(File file, TAFParseDiagnosticListener listener) throws IOException {
        try (InputStream is = IOUtil.asBufferedInputStream(file);){
            CompactMealy<String, String> compactMealy = TAFParser.parseMealy(is, listener);
            return compactMealy;
        }
    }

    public static CompactMealy<String, String> parseMealy(String string, TAFParseDiagnosticListener listener) {
        return TAFParser.parseMealy(new StringReader(string), listener);
    }

    public static FiniteAlphabetAutomaton<?, String, ?> parseAny(InputStream stream, TAFParseDiagnosticListener listener) throws IOException {
        try (Reader r = IOUtil.asUncompressedBufferedNonClosingUTF8Reader(stream);){
            FiniteAlphabetAutomaton<?, String, ?> finiteAlphabetAutomaton = TAFParser.parseAny(r, listener);
            return finiteAlphabetAutomaton;
        }
    }

    public static FiniteAlphabetAutomaton<?, String, ?> parseAny(Reader reader, TAFParseDiagnosticListener listener) {
        InternalTAFParser parser = new InternalTAFParser(reader);
        parser.setDiagnosticListener(listener);
        try {
            Type type = parser.type();
            switch (type) {
                case DFA: {
                    DefaultTAFBuilderDFA builder = new DefaultTAFBuilderDFA(parser);
                    parser.dfaBody(builder);
                    return (FiniteAlphabetAutomaton)builder.finish();
                }
                case MEALY: {
                    DefaultTAFBuilderMealy builder = new DefaultTAFBuilderMealy(parser);
                    parser.mealyBody(builder);
                    return (FiniteAlphabetAutomaton)builder.finish();
                }
            }
            throw new IllegalStateException("Unknown type " + (Object)((Object)type));
        }
        catch (ParseException ex) {
            throw new TAFFormatException(ex);
        }
    }

    public static FiniteAlphabetAutomaton<?, String, ?> parseAny(File file, TAFParseDiagnosticListener listener) throws IOException {
        try (InputStream is = IOUtil.asBufferedInputStream(file);){
            FiniteAlphabetAutomaton<?, String, ?> finiteAlphabetAutomaton = TAFParser.parseAny(is, listener);
            return finiteAlphabetAutomaton;
        }
    }

    public static FiniteAlphabetAutomaton<?, String, ?> parseAny(String string, TAFParseDiagnosticListener listener) {
        return TAFParser.parseAny(new StringReader(string), listener);
    }
}

