/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.conformance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.SPA;
import net.automatalib.common.util.collection.AbstractTwoLevelIterator;
import net.automatalib.util.automaton.procedural.ATRSequences;
import net.automatalib.util.automaton.procedural.SPAs;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SPATestsIterator<I>
extends AbstractTwoLevelIterator<I, Word<I>, Word<I>> {
    private final SPA<?, I> spa;
    private final ProceduralInputAlphabet<I> alphabet;
    private final BiFunction<DFA<?, I>, Collection<I>, Iterator<Word<I>>> conformanceTestProvider;
    private final Collection<I> proceduralInputs;
    private final ATRSequences<I> atrSequences;

    public SPATestsIterator(SPA<?, I> spa, BiFunction<DFA<?, I>, Collection<I>, Iterator<Word<I>>> conformanceTestProvider) {
        this(spa, (ProceduralInputAlphabet<I>)spa.getInputAlphabet(), conformanceTestProvider);
    }

    public SPATestsIterator(SPA<?, I> spa, ProceduralInputAlphabet<I> alphabet, BiFunction<DFA<?, I>, Collection<I>, Iterator<Word<I>>> conformanceTestProvider) {
        super(SPATestsIterator.availableProceduresIterator(spa, alphabet));
        this.spa = spa;
        this.alphabet = alphabet;
        this.conformanceTestProvider = conformanceTestProvider;
        this.proceduralInputs = spa.getProceduralInputs(alphabet);
        this.atrSequences = SPAs.computeATRSequences(spa, alphabet);
    }

    @Override
    protected Iterator<Word<I>> l2Iterator(I callSymbol) {
        @NonNull DFA dfa = (DFA)this.spa.getProcedure(callSymbol);
        return this.conformanceTestProvider.apply(dfa, this.proceduralInputs);
    }

    @Override
    protected Word<I> combine(I callSymbol, Word<I> testSequence) {
        @NonNull Word<I> as = this.atrSequences.accessSequences.get(callSymbol);
        Word<Object> ts = this.alphabet.expand(testSequence, this.atrSequences.terminatingSequences::get);
        @NonNull Word<I> rs = this.atrSequences.returnSequences.get(callSymbol);
        return Word.fromWords(as, ts, rs);
    }

    private static <I> Iterator<I> availableProceduresIterator(SPA<?, I> spa, ProceduralInputAlphabet<I> alphabet) {
        Map procedures = spa.getProcedures();
        ArrayList result = new ArrayList(procedures.size());
        for (Object i : alphabet.getCallAlphabet()) {
            if (!procedures.containsKey(i)) continue;
            result.add(i);
        }
        return result.iterator();
    }
}

