/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.transducer;

import java.util.Collection;
import net.automatalib.automaton.transducer.MutableMealyMachine;
import net.automatalib.util.automaton.Automata;

public final class MutableMealyMachines {
    private MutableMealyMachines() {
    }

    public static <I, O> void complete(MutableMealyMachine<?, I, ?, O> mealy, Collection<? extends I> inputs, O undefinedOutput) {
        MutableMealyMachines.complete(mealy, inputs, undefinedOutput, false);
    }

    public static <S, I, O> void complete(MutableMealyMachine<S, I, ?, O> mealy, Collection<? extends I> inputs, O undefinedOutput, boolean minimize) {
        Object sink = null;
        for (Object state : mealy) {
            for (I input : inputs) {
                Object succ = mealy.getSuccessor(state, input);
                if (succ != null) continue;
                if (sink == null) {
                    sink = mealy.addState();
                    for (I inputSym : inputs) {
                        mealy.addTransition(sink, inputSym, sink, undefinedOutput);
                    }
                }
                mealy.addTransition(state, input, sink, undefinedOutput);
            }
        }
        if (minimize) {
            Automata.invasiveMinimize(mealy, inputs);
        }
    }
}

