/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.Arrays;
import java.util.Collection;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.MinimizationResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BlockMap<V>
implements MutableMapping<Block<?, ?>, V> {
    private final @Nullable Object[] storage;

    public BlockMap(MinimizationResult<?, ?> minResult) {
        this.storage = new Object[minResult.getNumBlocks()];
    }

    @Override
    public V get(Block<?, ?> block) {
        return (V)this.storage[block.getId()];
    }

    @Override
    public V put(Block<?, ?> block, V value) {
        Object old = this.storage[block.getId()];
        this.storage[block.getId()] = value;
        return (V)old;
    }

    public Collection<V> values() {
        return Arrays.asList(this.storage);
    }
}

