/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.partitionrefinement;

import java.util.Arrays;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StateSignature {
    private final @Nullable Object[] properties;

    private StateSignature(@Nullable Object[] properties) {
        this.properties = properties;
    }

    @SafeVarargs
    public static <SP, TP> StateSignature byFullSignature(SP stateProperty, TP ... transitionProperties) {
        @Nullable Object[] properties = new Object[transitionProperties.length + 1];
        System.arraycopy(transitionProperties, 0, properties, 0, transitionProperties.length);
        properties[transitionProperties.length] = stateProperty;
        return new StateSignature(properties);
    }

    public static StateSignature byFullSignature(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> automaton, int state) {
        int numInputs = automaton.numInputs();
        @Nullable Object[] properties = new Object[numInputs + 1];
        StateSignature.fillTransitionProperties(automaton, state, properties);
        properties[numInputs] = automaton.getStateProperty(state);
        return new StateSignature(properties);
    }

    public static <S, I> StateSignature byFullSignature(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Alphabet<I> alphabet, S state) {
        int numInputs = alphabet.size();
        @Nullable Object[] properties = new Object[numInputs + 1];
        StateSignature.fillTransitionProperties(automaton, alphabet, state, properties);
        properties[numInputs] = automaton.getStateProperty(state);
        return new StateSignature(properties);
    }

    @SafeVarargs
    public static <TP> StateSignature byTransitionProperties(TP ... properties) {
        return new StateSignature(properties);
    }

    public static StateSignature byTransitionProperties(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> automaton, int state) {
        int numInputs = automaton.numInputs();
        @Nullable Object[] properties = new Object[numInputs];
        StateSignature.fillTransitionProperties(automaton, state, properties);
        return new StateSignature(properties);
    }

    public static <S, I> StateSignature byTransitionProperties(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Alphabet<I> alphabet, S state) {
        int numInputs = alphabet.size();
        @Nullable Object[] properties = new Object[numInputs];
        StateSignature.fillTransitionProperties(automaton, alphabet, state, properties);
        return new StateSignature(properties);
    }

    private static void fillTransitionProperties(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> automaton, int state, @Nullable Object[] properties) {
        int numInputs = automaton.numInputs();
        for (int i = 0; i < numInputs; ++i) {
            properties[i] = automaton.getTransitionProperty(state, i);
        }
    }

    private static <S, I> void fillTransitionProperties(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Alphabet<I> alphabet, S state, @Nullable Object[] properties) {
        int numInputs = alphabet.size();
        for (int i = 0; i < numInputs; ++i) {
            I sym = alphabet.getSymbol(i);
            properties[i] = automaton.getTransitionProperty(state, sym);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateSignature)) {
            return false;
        }
        StateSignature that = (StateSignature)o;
        return Arrays.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Arrays.hashCode(this.properties);
    }
}

