/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.AutomataLibProperty;
import net.automatalib.AutomataLibSettings;
import net.automatalib.automaton.Automaton;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.graph.Graph;
import net.automatalib.graph.concept.GraphViewable;
import net.automatalib.visualization.VPManager;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.visualization.VisualizationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Visualization {
    private static final Logger LOGGER = LoggerFactory.getLogger(Visualization.class);
    private static final Visualization INSTANCE = new Visualization();
    private final VisualizationProvider provider;

    private Visualization() {
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        String providerId = settings.getProperty(AutomataLibProperty.VISUALIZATION_PROVIDER);
        VisualizationProvider vp = null;
        VPManager manager = new VPManager();
        manager.load();
        if (providerId != null && (vp = manager.getProviderById(providerId)) == null) {
            LOGGER.error("No provider found with id '{}'. Defaulting to dummy provider...", (Object)providerId);
        }
        if (vp == null) {
            vp = manager.getBestProvider();
        }
        this.provider = vp;
    }

    public static <N, E> void visualize(Graph<N, E> graph) {
        Visualization.visualize(graph, true);
    }

    @SafeVarargs
    public static <N, E> void visualize(Graph<N, E> graph, VisualizationHelper<N, ? super E> ... additionalHelpers) {
        Visualization.visualize(graph, true, additionalHelpers);
    }

    public static <N, E> void visualize(Graph<N, E> graph, boolean modal) {
        Visualization.visualize(graph, modal, Collections.emptyMap());
    }

    @SafeVarargs
    public static <N, E> void visualize(Graph<N, E> graph, boolean modal, VisualizationHelper<N, ? super E> ... additionalHelpers) {
        Visualization.visualize(graph, modal, Collections.emptyMap(), additionalHelpers);
    }

    public static <N, E> void visualize(Graph<N, E> graph, boolean modal, Map<String, String> options) {
        INSTANCE.visualizeInternal(graph, modal, options);
    }

    @SafeVarargs
    public static <N, E> void visualize(Graph<N, E> graph, boolean modal, Map<String, String> options, VisualizationHelper<N, ? super E> ... additionalHelpers) {
        INSTANCE.visualizeInternal(graph, modal, options, additionalHelpers);
    }

    public static void visualize(GraphViewable gv) {
        Visualization.visualize(gv, true);
    }

    public static void visualize(GraphViewable gv, boolean modal) {
        Visualization.visualize(gv, modal, Collections.emptyMap());
    }

    public static void visualize(GraphViewable gv, boolean modal, Map<String, String> options) {
        Visualization.visualize(gv.graphView(), modal, options);
    }

    public static <S, I, T> void visualize(Automaton<S, I, T> graph, Collection<? extends I> inputs) {
        Visualization.visualize(graph, inputs, true);
    }

    @SafeVarargs
    public static <S, I, T> void visualize(Automaton<S, I, T> graph, Collection<? extends I> inputs, VisualizationHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) {
        Visualization.visualize(graph, inputs, true, additionalHelpers);
    }

    public static <S, I, T> void visualize(Automaton<S, I, T> graph, Collection<? extends I> inputs, boolean modal) {
        Visualization.visualize(graph, inputs, modal, Collections.emptyMap());
    }

    @SafeVarargs
    public static <S, I, T> void visualize(Automaton<S, I, T> graph, Collection<? extends I> inputs, boolean modal, VisualizationHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) {
        Visualization.visualize(graph, inputs, modal, Collections.emptyMap(), additionalHelpers);
    }

    public static <S, I, T> void visualize(Automaton<S, I, T> graph, Collection<? extends I> inputs, boolean modal, Map<String, String> options) {
        INSTANCE.visualizeInternal(graph.transitionGraphView(inputs), modal, options);
    }

    @SafeVarargs
    public static <S, I, T> void visualize(Automaton<S, I, T> graph, Collection<? extends I> inputs, boolean modal, Map<String, String> options, VisualizationHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) {
        INSTANCE.visualizeInternal(graph.transitionGraphView(inputs), modal, options, additionalHelpers);
    }

    private <N, E> void visualizeInternal(Graph<N, E> graph, boolean modal, Map<String, String> options) {
        this.provider.visualize(graph, Collections.emptyList(), modal, options);
    }

    @SafeVarargs
    private final <N, E> void visualizeInternal(Graph<N, E> graph, boolean modal, Map<String, String> options, VisualizationHelper<N, ? super E> ... additionalHelpers) {
        this.provider.visualize(graph, Arrays.asList(additionalHelpers), modal, options);
    }
}

