/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.word;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Function;
import net.automatalib.word.SharedWord;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

final class LetterWord<I>
extends Word<I> {
    private final I letter;

    LetterWord(I letter) {
        this.letter = letter;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public java.util.Iterator<I> iterator() {
        return new Iterator<I>(this.letter);
    }

    @Override
    public Spliterator<I> spliterator() {
        return Collections.singleton(this.letter).spliterator();
    }

    @Override
    public Word<I> subWordInternal(int fromIndex, int toIndex) {
        if (fromIndex > 0 || toIndex == 0) {
            return Word.epsilon();
        }
        return this;
    }

    @Override
    public void writeToArray(int offset, @Nullable Object[] array, int tgtOffset, int length) {
        if (offset == 0 && length > 0) {
            array[tgtOffset] = this.letter;
        }
    }

    @Override
    public I getSymbol(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.letter;
    }

    @Override
    public List<I> asList() {
        return Collections.singletonList(this.letter);
    }

    @Override
    public I lastSymbol() {
        return this.letter;
    }

    @Override
    public Word<I> append(I symbol) {
        @Nullable Object[] array = new Object[]{this.letter, symbol};
        return new SharedWord(array);
    }

    @Override
    public Word<I> prepend(I symbol) {
        @Nullable Object[] array = new Object[]{symbol, this.letter};
        return new SharedWord(array);
    }

    @Override
    public boolean isPrefixOf(Word<?> other) {
        return !other.isEmpty() && Objects.equals(this.letter, other.getSymbol(0));
    }

    @Override
    public Word<I> longestCommonPrefix(Word<?> other) {
        if (this.isPrefixOf(other)) {
            return this;
        }
        return Word.epsilon();
    }

    @Override
    public boolean isSuffixOf(Word<?> other) {
        return !other.isEmpty() && Objects.equals(this.letter, other.lastSymbol());
    }

    @Override
    public Word<I> longestCommonSuffix(Word<?> other) {
        if (this.isSuffixOf(other)) {
            return this;
        }
        return Word.epsilon();
    }

    @Override
    public Word<I> flatten() {
        return this;
    }

    @Override
    public Word<I> trimmed() {
        return this;
    }

    @Override
    public <T> Word<T> transform(Function<? super I, ? extends T> transformer) {
        T transformed = transformer.apply(this.letter);
        return new LetterWord<T>(transformed);
    }

    private static final class Iterator<I>
    implements java.util.Iterator<I> {
        private final I letter;
        private boolean next = true;

        Iterator(I letter) {
            this.letter = letter;
        }

        @Override
        public boolean hasNext() {
            return this.next;
        }

        @Override
        public I next() {
            if (this.next) {
                this.next = false;
                return this.letter;
            }
            throw new NoSuchElementException();
        }
    }
}

