/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.acex;

import de.learnlib.acex.AbstractCounterexample;
import de.learnlib.acex.AbstractNamedAcexAnalyzer;
import de.learnlib.acex.AcexAnalysisAlgorithms;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class AcexAnalyzers {
    public static final AbstractNamedAcexAnalyzer LINEAR_FWD = new AbstractNamedAcexAnalyzer("LinearFwd"){

        @Override
        public int analyzeAbstractCounterexample(AbstractCounterexample<?> acex, int low, int high) {
            return AcexAnalysisAlgorithms.linearSearchFwd(acex, low, high);
        }
    };
    public static final AbstractNamedAcexAnalyzer LINEAR_BWD = new AbstractNamedAcexAnalyzer("LinearBwd"){

        @Override
        public int analyzeAbstractCounterexample(AbstractCounterexample<?> acex, int low, int high) {
            return AcexAnalysisAlgorithms.linearSearchBwd(acex, low, high);
        }
    };
    public static final AbstractNamedAcexAnalyzer BINARY_SEARCH_BWD = new AbstractNamedAcexAnalyzer("BinarySearchBwd"){

        @Override
        public int analyzeAbstractCounterexample(AbstractCounterexample<?> acex, int low, int high) {
            return AcexAnalysisAlgorithms.binarySearchRight(acex, low, high);
        }
    };
    public static final AbstractNamedAcexAnalyzer BINARY_SEARCH_FWD = new AbstractNamedAcexAnalyzer("BinarySearchFwd"){

        @Override
        public int analyzeAbstractCounterexample(AbstractCounterexample<?> acex, int low, int high) {
            return AcexAnalysisAlgorithms.binarySearchLeft(acex, low, high);
        }
    };
    public static final AbstractNamedAcexAnalyzer EXPONENTIAL_BWD = new AbstractNamedAcexAnalyzer("ExponentialBwd"){

        @Override
        public int analyzeAbstractCounterexample(AbstractCounterexample<?> acex, int low, int high) {
            return AcexAnalysisAlgorithms.exponentialSearchBwd(acex, low, high);
        }
    };
    public static final AbstractNamedAcexAnalyzer EXPONENTIAL_FWD = new AbstractNamedAcexAnalyzer("ExponentialFwd"){

        @Override
        public int analyzeAbstractCounterexample(AbstractCounterexample<?> acex, int low, int high) {
            return AcexAnalysisAlgorithms.exponentialSearchFwd(acex, low, high);
        }
    };
    public static final Map<String, AbstractNamedAcexAnalyzer> FWD_ANALYZERS = AcexAnalyzers.createMap(LINEAR_FWD, EXPONENTIAL_FWD, BINARY_SEARCH_FWD);
    public static final Map<String, AbstractNamedAcexAnalyzer> BWD_ANALYZERS = AcexAnalyzers.createMap(LINEAR_BWD, EXPONENTIAL_BWD, BINARY_SEARCH_BWD);
    public static final Map<String, AbstractNamedAcexAnalyzer> ALL_ANALYZERS = AcexAnalyzers.createMap(FWD_ANALYZERS, BWD_ANALYZERS);

    private AcexAnalyzers() {
    }

    private static Map<String, AbstractNamedAcexAnalyzer> createMap(AbstractNamedAcexAnalyzer ... analyzers) {
        HashMap<String, AbstractNamedAcexAnalyzer> analyzerMap = new HashMap<String, AbstractNamedAcexAnalyzer>(analyzers.length * 3 / 2);
        for (AbstractNamedAcexAnalyzer a : analyzers) {
            analyzerMap.put(a.getName(), a);
        }
        return Collections.unmodifiableMap(analyzerMap);
    }

    @SafeVarargs
    private static Map<String, AbstractNamedAcexAnalyzer> createMap(Map<String, AbstractNamedAcexAnalyzer> ... maps) {
        HashMap<String, AbstractNamedAcexAnalyzer> result = new HashMap<String, AbstractNamedAcexAnalyzer>();
        for (Map<String, AbstractNamedAcexAnalyzer> map : maps) {
            result.putAll(map);
        }
        return result;
    }

    public static Collection<AbstractNamedAcexAnalyzer> getAnalyzers(Direction dir) {
        switch (dir) {
            case FORWARD: {
                return AcexAnalyzers.getForwardAnalyzers();
            }
            case BACKWARD: {
                return AcexAnalyzers.getBackwardAnalyzers();
            }
        }
        throw new IllegalArgumentException();
    }

    public static Collection<AbstractNamedAcexAnalyzer> getForwardAnalyzers() {
        return FWD_ANALYZERS.values();
    }

    public static Collection<AbstractNamedAcexAnalyzer> getBackwardAnalyzers() {
        return BWD_ANALYZERS.values();
    }

    public static Collection<AbstractNamedAcexAnalyzer> getAllAnalyzers() {
        return ALL_ANALYZERS.values();
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

