/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.aaar;

import de.learnlib.algorithm.aaar.abstraction.AbstractAbstractionTree;
import java.util.Collection;
import java.util.function.Function;
import net.automatalib.automaton.fsa.DFA;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TranslatingDFA<S, AI, CI>
implements DFA<S, CI> {
    private final DFA<S, CI> delegate;
    private final Function<CI, ? extends AbstractAbstractionTree<AI, CI, ?>> treeFetcher;

    public TranslatingDFA(DFA<S, CI> delegate, Function<CI, ? extends AbstractAbstractionTree<AI, CI, ?>> treeFetcher) {
        this.delegate = delegate;
        this.treeFetcher = treeFetcher;
    }

    @Override
    public Collection<S> getStates() {
        return this.delegate.getStates();
    }

    @Override
    public @Nullable S getTransition(S s2, CI i) {
        AbstractAbstractionTree<AI, CI, ?> tree = this.treeFetcher.apply(i);
        AI ai = tree.getAbstractSymbol(i);
        CI ci = tree.getRepresentative(ai);
        return (S)this.delegate.getTransition(s2, ci);
    }

    @Override
    public boolean isAccepting(S s2) {
        return this.delegate.isAccepting(s2);
    }

    @Override
    public @Nullable S getInitialState() {
        return this.delegate.getInitialState();
    }
}

